<?php if (!empty($ecommerceTracking) && Configure::read('BuzzPurchase.gtmEcommerce') === true): ?>
	<?php
		$items = [];
		foreach ($ecommerceTracking['items'] as $trackingItem) {
			$items[] = [
				'sku' => $trackingItem['sku'],
				'name' => $trackingItem['name'],
				'price' => $trackingItem['price'],
				'quantity' => $trackingItem['quantity'],
				'category' => $trackingItem['category'],
			];
		}
		$data = [
			'event' => 'ecomtransaction',
			'transactionId' => $ecommerceTracking['salesRef'],
			'transactionAffiliation' => Configure::read('SiteSetting.site_title'),
			'transactionTotal' => $ecommerceTracking['revenue'],
			'transactionTax' => $ecommerceTracking['tax'],
			'transactionShipping' => $ecommerceTracking['shipping'],
			'transactionProducts' => $items,
		];
	?>
	<script>
	if (cookie('gtm_tracking_<?=$ecommerceTracking['salesRef']?>') != '1') {
		window.dataLayer = window.dataLayer || []
		dataLayer.push(<?= json_encode($data) ?>);

		cookie('gtm_tracking_<?=$ecommerceTracking['salesRef']?>', '1', 86400000);
	}
	</script>
<?php endif; ?>
