<?php if (!empty($ecommerceTracking)): ?>
	<?php
		$gaTransaction = [
			'id' => $ecommerceTracking['salesRef'],
			'revenue' => $ecommerceTracking['revenue'],
			'shipping' => $ecommerceTracking['shipping'],
		];
		$gaItems = [];
		foreach ($ecommerceTracking['items'] as $trackingItem) {
			$gaItems[] = [
				'id' => $ecommerceTracking['salesRef'],
				'name' => $trackingItem['name'],
				'sku' => $trackingItem['sku'],
				'price' => $trackingItem['price'],
				'quantity' => $trackingItem['quantity'],
				'category' => $trackingItem['category'],
			];
		}
	?>
	<script type="text/javascript">
		ga('require', 'ecommerce', 'ecommerce.js');
		if (cookie('ecommerce_tracking_<?=$ecommerceTracking['salesRef']?>') != '1') {
			ga('ecommerce:addTransaction', <?= json_encode($gaTransaction) ?>);
			<?php foreach ($gaItems as $gaItem): ?>
				ga('ecommerce:addItem', <?= json_encode($gaItem) ?>);
			<?php endforeach; ?>
			ga('ecommerce:send');

			cookie('ecommerce_tracking_<?=$ecommerceTracking['salesRef']?>', '1', 86400000);
		}
	</script>
<?php endif; ?>
