<?php

$model = !empty($model) ? $model : 'Payment';

echo $this->Form->input(
	$model . '.card_name',
	['label' => __d('buzz_purchase', 'Cardholder\'s name'), 'autocomplete' => 'off']
);
echo $this->Form->input(
	$model . '.card_type',
	['label' => __d('buzz_purchase', 'Card type'), 'autocomplete' => 'off']
);
echo $this->Form->input(
	$model . '.card_number',
	['label' => __d('buzz_purchase', 'Card number'), 'type' => 'number', 'autocomplete' => 'off']
);

$class = 'input input--x-small start-date hidden';
if ($this->Form->isFieldError($model . '.start_date')) {
	$class .= ' error';
}
echo $this->Html->tag('div', null, ['class' => $class]);
echo $this->Form->input(
	$model . '.start_month',
	[
		'label' => __d('buzz_purchase', 'Start date'),
		'div' => 'select',
		'empty' => __d('buzz_purchase', 'MM'),
		'type' => 'select',
		'options' => $months,
		'autocomplete' => 'off',
	]
);
echo $this->Form->input(
	$model . '.start_year',
	[
		'label' => false,
		'div' => 'select',
		'empty' => __d('buzz_purchase', 'YY'),
		'type' => 'select',
		'options' => $pastYears,
		'autocomplete' => 'off'
	]
);
echo $this->Form->error($model . '.start_date');
echo $this->Html->tag('/div');

$class = 'input input--x-small required select';
if ($this->Form->isFieldError($model . '.expiry_date')) {
	$class .= ' error';
}
echo $this->Html->tag('div', null, ['class' => $class]);
echo $this->Form->input(
	$model . '.expiry_month',
	[
		'label' => __d('buzz_purchase', 'Expiry date'),
		'div' => 'select',
		'empty' => __d('buzz_purchase', 'MM'),
		'type' => 'select',
		'options' => $months,
		'autocomplete' => 'off'
	]
);
echo $this->Form->input(
	$model . '.expiry_year',
	[
		'label' => false,
		'div' => 'select',
		'empty' => __d('buzz_purchase', 'YY'),
		'type' => 'select',
		'options' => $years,
		'autocomplete' => 'off'
	]
);
echo $this->Form->error($model . '.expiry_date');
echo $this->Html->tag('/div');

echo $this->Form->input(
	$model . '.issue_number',
	['label' => __d('buzz_purchase', 'Issue number'), 'div' => 'input input--small issue-number hidden', 'type' => 'number', 'autocomplete' => 'off']
);
echo $this->Form->input(
	$model . '.security_number',
	['label' => __d('buzz_purchase', 'Security digits (CCV)'), 'div' => 'input input--small', 'type' => 'number', 'autocomplete' => 'off']
);
