<?php
App::uses('Component', 'Controller');

class PurchaseComponent extends Component {

	protected $_controller = null;

/**
 * Sets a reference to the calling controller from within the component.
 *
 * @see Component::initialize()
 */
	public function initialize(Controller $controller) {
		parent::initialize($controller);
		$this->_controller = $controller;

		// If we've got Google Conversion configured set the View variable.
		if (Configure::check('BuzzPurchase.google_conversion.id') === true) {
			$this->_controller->set('googleConversion', Configure::read('BuzzPurchase.google_conversion'));
		}
	}

/**
 * Returns the configured card types.
 *
 * @return array
 */
	public function getCardTypes() {
		$this->_controller->loadModel('BuzzPurchase.Payment');
		return $this->_controller->Payment->getCardTypes();
	}

/**
 * Returns an array of numeric months for card details.
 *
 * @return array
 */
	public function getMonths() {
		$data = [];
		for ($m = 1; $m <= 12; $m++) {
			$month = str_pad($m, '2', 0, STR_PAD_LEFT);
			$data[$month] = $month;
		}
		return $data;
	}

/**
 * Returns an array of years for card details.
 *
 * @return array
 */
	public function getYears() {
		$data = [];
		$year = date('Y');
		$maxYear = $year + 25;
		for ($year; $year < $maxYear; $year++) {
			$data[substr($year, 2)] = $year;
		}
		return $data;
	}

/**
 * Returns an array of past years for card details.
 *
 * @return array
 */
	public function getPastYears() {
		$data = [];
		$year = date('Y');
		$minYear = $year - 25;
		for ($year; $year > $minYear; $year--) {
			$data[substr($year, 2)] = $year;
		}
		return $data;
	}

}
