<?php
App::uses('Component', 'Controller');

class EcommerceTrackingComponent extends Component {

	protected $_controller = null;

	protected $_trackingItems = [];

/**
 * Sets a reference to the calling controller from within the component.
 *
 * @see Component::initialize()
 */
	public function initialize(Controller $controller) {
		parent::initialize($controller);
		$this->_controller = $controller;
	}

/**
 * Add an item for tracking
 * @param string $name Product name
 * @param string $sku Product SKU
 * @param float $price Unit price
 * @param int $quantity Quantity
 * @param array $optionals Additional data (usually optional values to make this more function extendable)
 */
	public function addItem($name, $sku, $price, $quantity = 1, $optionals = []) {
		$data = [
			'name' => $name,
			'sku' => $sku,
			'price' => $price,
			'quantity' => $quantity
		];
		$data['category'] = !empty($optionals['category']) ? $optionals['category'] : '';
		$this->_trackingItems[] = $data;

		return $data;
	}

/**
 * Returns transaction data for e-commerce tracking.
 *
 * @param string $salesRef Transaction ID
 * @param float $totalCost Total cost
 * @param string $currency Currency
 * @param float $tax Tax cost
 * @param float $shippingCost Optional shipping/delivery cost
 * @param string $discountCode Discount code
 * @return string
 */
	public function transaction($salesRef, $totalCost, $currency = null, $tax = 0, $shippingCost = 0, $discountCode = '') {
		$data = [
			'salesRef' => $salesRef,
			'revenue' => $totalCost,
			'currency' => $currency ?: CakeNumber::defaultCurrency(),
			'tax' => $tax,
			'shipping' => $shippingCost,
			'discountCode' => $discountCode,
			'items' => $this->_trackingItems,
		];

		return $data;
	}

}
