<?php

$config = [
	'BuzzPurchase' => [
		// Configure whether payments are to be taken on or off site
		'onsite' => true,
		// Define the available card types for payment (indexed by the card
		// name used by Cake for validation).
		'card_types' => [
			'visa' => 'Visa',
			'mc' => 'Mastercard',
			'maestro' => 'Maestro',
		],
		// Enable/Disable GTM Enhanced Ecommerce tracking for purchasee (disabled by default).
		'gtmEnhancedEcommerce' => false,
		// Enable/Disable Facebook Pixel tracking for purchases (disabled by default).
		'fbPixel' => false,
		// Enable/Disable Adviral Media Pixel tracking for purchases (disabled by default).
		'adviralMediaPixel' => false,
		// Configuration for Google Conversion tracking.
		'google_conversion' => [
			'id' => null,
			'label' => null,
			'color' => 'ffffff',
			'format' => '3'
		],
		// Enable/Disable Site Gainer tracking for purchases (disabled by default).
		'siteGainer' => false,
		// If purchases are taxed set the percentage value of the Tax, e.g. '10' for 10%.
		'taxPercent' => null,
		// Tax label in baskets.
		'taxLabel' => __d('buzz_purchase', 'VAT'),
		// Enable/Disable whether the percentage of Tax is shown.
		'showPercent' => true,
		// Enable/Disable whether the value of the Tax is shown.
		'showAmount' => true
	]
];
