<?php
$this->extend('/Common/view');
if (! empty($showOrder) && $showOrder):
	$title = __d('buzz_photos', 'Your Purchase is Complete');
else:
	$title = __d('buzz_photos', 'Purchased Photos');
endif;

if (!empty($data)):
	$title = $this->I18n->translate($data, 'Page.title');
endif;
$this->assign('title', $title);
?>
<div class="row">
	<div class="col-xs-12">
		<?php if (! empty($showOrder) && $showOrder): ?>

			<h2><?php echo __d('buzz_photos', 'Your photo purchase was successfully completed.'); ?></h2>
			<?php if (!empty($data)): ?>
				<?php echo $this->I18n->translate($data, 'Page.body'); ?>
			<?php else: ?>
				<p class="flash flash--success"><?php echo __d('buzz_photos', 'An email containing your photos has been sent to you. You can also download them below.'); ?></p>
			<?php endif; ?>
		<?php
			endif;
		?>
	</div>
</div>

<?php
if (! empty($showOrder) && $showOrder):
	echo $this->element('BuzzPhotos.order_table_full', [
		'data' => $order,
		'paid' => true
	]);
endif;

echo $this->element('BuzzPhotos.purchased_photos');
?>

<?= $this->element('BuzzPurchase.ecommerce_tracking', [
		'total' => $order['Order']['total_price'],
		'ecommerceTracking' => $ecommerceTracking
	]);
?>
