<div class='edit-form'>

	<div class='edit-form__header'>
		<h1 class='title'><?php echo $this->InflectorExt->camelToPluralize($displayName); ?> <span>Administration</span></h1>
		<h2 class='title edit-form__title'>
			<?php
				if (isset($title_for_layout)):

					echo $title_for_layout;

				else:

					echo $this->InflectorExt->camelToHumanize(preg_replace('|^admin_|i', '', $this->request->action));
					echo $this->InflectorExt->camelToHumanize($displayName);

				endif;
			?>
		</h2>

		<?php echo $this->Element('toolbar'); ?>
	</div>

	<?php
		echo $this->Html->script('admin_form', array('inline'=>false));

		echo $this->Form->create($primaryModel, array(
			'inputDefaults'=>array(
				'empty'=>''
			),
			'type' => 'file',
			'class' => 'cr'
		));

	?>

	<div class='tab__content' data-title='Order Details'>
		<div class="field">
			<div class="field__label">Sales Ref</div>
			<div class="field__value">
				<?= h($this->request->data['Order']['sales_ref']) ?>
			</div>
		</div>
		<div class="field">
			<div class="field__label">UUID</div>
			<div class="field__value">
				<?= h($this->request->data['Order']['uuid']) ?>
			</div>
		</div>
		<div class="field">
			<div class="field__label">First Name</div>
			<div class="field__value">
				<?= h($this->request->data['Order']['first_name']) ?>
			</div>
		</div>
		<div class="field">
			<div class="field__label">Last Name</div>
			<div class="field__value">
				<?= h($this->request->data['Order']['last_name']) ?>
			</div>
		</div>
		<div class="field">
			<div class="field__label">Email</div>
			<div class="field__value">
				<?= h($this->request->data['Order']['email']) ?>
			</div>
		</div>
		<div class="field">
			<div class="field__label">Phone</div>
			<div class="field__value">
				<?= h($this->request->data['Order']['phone']) ?>
			</div>
		</div>
		<div class="field">
			<div class="field__label">Customer Address</div>
			<div class="field__value">
				<?= $this->Address->format($this->request->data['CustomerAddress']) ?>
			</div>
		</div>
		<div class="field">
			<div class="field__label">Billing Address</div>
			<div class="field__value">
				<?= nl2br(h($this->request->data['Order']['billing_address'])) ?>
			</div>
		</div>
		<div class="field">
			<div class="field__label">Order State</div>
			<div class="field__value">
				<?= h($this->request->data['OrderState']['name']) ?>
			</div>
		</div>
		<div class="field">
			<div class="field__label">Location</div>
			<div class="field__value">
				<?= h($this->request->data['Site']['name']) ?>
			</div>
		</div>
		<div class="field">
			<div class="field__label">Subtotal</div>
			<div class="field__value">
				<?= $this->Number->currency($this->request->data['Order']['sub_total']) ?>
			</div>
		</div>
		<div class="field">
			<div class="field__label">Discount</div>
			<div class="field__value">
				<?= $this->Number->currency($this->request->data['Order']['discount']) ?>
			</div>
		</div>
		<div class="field">
			<div class="field__label">Total</div>
			<div class="field__value">
				<?= $this->Number->currency($this->request->data['Order']['total_price']) ?>
			</div>
		</div>
		<?php if (Configure::read('BuzzPhotos.show_newsletter_opt_in') === true): ?>
			<div class="field">
				<div class="field__label">Newsletter Opt-in</div>
				<div class="field__value">
					<?php if ($this->request->data['Order']['newsletter_opt_in']): ?>
						<i class="fa fa-check"></i>
					<?php else: ?>
						<i class="fa fa-times"></i>
					<?php endif; ?>
				</div>
			</div>
		<?php endif; ?>
	</div>


	<?php if (! empty($this->request->data['OrderItem'])): ?>
		<div class="tab__content" data-title="Photos Ordered">
			<table class="table">
				<thead>
					<tr>
						<th><?=__d('buzz_photos', 'Photo')?></th>
						<th><?=__d('buzz_photos', 'Unique Identifier')?></th>
						<th><?=__d('buzz_photos', 'Price')?></th>
						<th><?=__d('buzz_photos', 'Sales Ref')?></th>
						<th><?=__d('buzz_photos', 'Api Ref')?></th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ($this->request->data['OrderItem'] as $item): ?>
						<tr>
							<td><?=$this->Html->image($item['thumb_url'], array('style' => 'max-height:150px;'))?></td>
							<td><?=$item['uuid']?></td>
							<td><?=$this->Number->currency($item['unit_price'])?></td>
							<td><?=$item['sales_ref']?></td>
							<td><?=$item['api_ref']?></td>
						</tr>
					<?php endforeach; ?>
				</tbody>
			</table>
		</div>
	<?php endif; ?>

	<?php if (! empty($transaction)): ?>
		<div class="tab__content" data-title="Transaction">

			<div class="preview">
				<h3><?=__d('buzz_photos', 'Transaction')?> #<?php echo $transaction['Transaction']['id']; ?></h3>

				<dl class="transactions_details">

					<dt><?=__d('buzz_photos', 'Transaction Date')?>:</dt>
					<dd><?php echo $this->Time->format('jS M Y, g:ia', $transaction['Transaction']['created']); ?></dd>

					<dt><?=__d('buzz_photos', 'Transaction Amount')?>:</dt>
					<dd><?= $this->Number->currency($transaction['Transaction']['transaction_amount']); ?></dd>

				</dl>

				<h2><?=__d('buzz_photos', 'Transaction Items')?></h2>

				<dl class="transactions_details items">

					<?php if (! empty($transaction['TransactionsItem'])): ?>
						<?php foreach ($transaction['TransactionsItem'] as $item): ?>

							<dt><?= $this->Number->currency($item['amount']); ?></dt>
							<dd><?php echo $item['description']; ?></dd>

						<?php endforeach; ?>
					<?php endif; ?>

				</dl>
			</div>


		</div>
	<?php endif; ?>

</div>
