<h2><?=__d('buzz_photos', 'Order Details')?></h2>

<div class="outline--septenary outline--thin background--white padding-gutters-1_2 basket">
	<?php foreach ($data['OrderItem'] as $item): ?>
		<div class="listing listing--booking">
			<div class="row">
				<div class="col-xs-12 col-sm-4 text-center lg-extra-gutters-1">
					<?=$this->Html->Image($item['thumb_url'], array('class' => 'img-responsive photo-module--thumb photo-module--thumb-order'))?>
				</div>
				<div class="col-xs-12 col-sm-6">
					<h3><?=__d('buzz_photos', 'Event Photograph')?></h3>
				</div>
				<div class="col-xs-12 col-sm-2 xs-extra-gutters-1">
					<strong><?=__d('buzz_photos', 'Price')?></strong>
					<span class="large"><?=$this->Number->currency($item['unit_price'])?></span>
				</div>
			</div>
		</div>

	<?php endforeach; ?>

	<div class="row">
		<div class="col-xs-12 col-sm-10"></div>
		<div class="col-xs-12 col-sm-2 basket__total text-right">
			<strong>
				<?=__d('buzz_photos', 'Sub-total')?>:
				<span class="large"><?=$this->Number->currency($data['Order']['sub_total'])?></span>
			</strong>
		</div>
	</div>
	<?php if (! empty($data['Order']['discount'])): ?>

		<div class="row">
			<div class="col-xs-12 col-sm-10"></div>
			<div class="col-xs-12 col-sm-2 basket__total text-right">
				<strong>
					<?=__d('buzz_photos', 'Discount')?>:
					<span class="large"><?=$this->Number->currency($data['Order']['discount'])?></span>
				</strong>
			</div>
		</div>
	<?php endif; ?>

	<?php if (Configure::check('BuzzPurchase.taxPercent')): ?>
		<div class="row">
			<div class="col-xs-12 basket__total text-right">
				<strong>
					<?= (Configure::check('BuzzPurchase.taxLabel') ? Configure::read('BuzzPurchase.taxLabel') : __('VAT')) ?> <span>
						<?php
							if (Configure::read('BuzzPurchase.showAmount') && Configure::check('BuzzPurchase.showPercent')) {
								echo "(" . Configure::read('BuzzPurchase.taxPercent') . "%) " . $this->Purchase->tax($data['Order']['total_price']);
							} elseif (Configure::read('BuzzPurchase.showAmount')) {
								echo $this->Purchase->tax($data['Order']['total_price']);
							} elseif (Configure::check('BuzzPurchase.showPercent')) {
								echo Configure::read('BuzzPurchase.taxPercent') . "%";
							}
						?>
					</span>
				</strong>
			</div>
		</div>
	<?php endif; ?>

	<div class="row">
		<div class="col-xs-12 col-sm-10"></div>
		<div class="col-xs-12 col-sm-2 basket__total basket__total text-right">
			<strong>
				<?=__d('buzz_photos', 'Total')?>:
				<span class="large"><?=$this->Number->currency($data['Order']['total_price'])?></span>
			</strong>
		</div>
	</div>
</div>
<div class="spacer"></div>
