<?= $this->Form->create() ?>
	<?= $this->Form->hidden('ActivityGroup.id', ['value' => $data['ActivityGroup']['id']]) ?>

	<div class="row">
		<div class="col-xs-12 col-sm-6">
			<?= $this->Form->input('email', [
				'label' => __d('buzz_photos', 'Please enter your email address'),
				'class' => 'js-buzz-photos-email-input',
			]) ?>
		</div>
		<div class="col-xs-12 col-sm-6">
			<?php if (! empty($data['FeatureImage'][0])): ?>
				<?=$this->Image->resize($data['FeatureImage'][0], array(
					'width' => 700,
					'class' => 'img-responsive'
				))?>
			<?php endif; ?>
		</div>
	</div>

	<div class="spacer"></div>

	<div class="photo-module__actions">
		<div class="row">
			<div class="col-xs-6">
				<?=$this->Html->link(
					__d('buzz_photos', 'Back'),
					array(
						'plugin' => 'buzz_photos',
						'controller' => 'activity_groups',
						'action' => 'index'
					),
					array(
						'class' => 'button button--light background--septenary left photo-module__button--back'
					)
				); ?>
				<div class="spacer"></div>
			</div>

			<div class="col-xs-6 text-right">
				<?=$this->Form->button(__d('buzz_photos', 'Proceed'), [
					'class' => 'button js-buzz-photos-email-proceed',
					'disabled' => true,
				]); ?>
			</div>
		</div>
	</div>

<?= $this->Form->end() ?>
