<?php if (empty($sites)): ?>
	<p>You've not added any sites yet. Sites will need configuring before you can use the Activity Photo system.</p>
<?php
else:
	$activityGroupSites = [];
	if (! empty($data['ActivityGroupSite'])):
		foreach ($data['ActivityGroupSite'] as $groupSite):
			$activityGroupSites[$groupSite['site_id']] = $groupSite;
		endforeach;
	endif;

	$i = 0;
	foreach ($sites as $site):
		$siteData = (isset($activityGroupSites[$site['Site']['id']]) ? $activityGroupSites[$site['Site']['id']] : null);

		echo $this->element('ActivityGroups/admin_site_form', [
			'site' => $site,
			'data' => $siteData,
			'index' => $i
		]);
		$i++;
	endforeach;
	?>
	<p>If you've got a site that you do not want to use this activity group on, simply leave it's applicable fields
		above blank and it won't be made available as an option.</p>
<?php
endif;
?>
