<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_photos', 'Where did your activity take place?'));

$siteCount = count($sites);
$colClass = 'col-xs-12 col-sm-3'; // supports 4 items per row
$firstColClass = null;

if ($siteCount == 3):
	$colClass = 'col-xs-12 col-sm-4';
elseif ($siteCount == 2):
	$colClass = 'col-xs-12 col-sm-3';
	$firstColClass = $colClass . ' col-sm-offset-3';
endif;
?>

	<form action="" method="post">
		<?= $this->Form->addField('ActivityGroup.id', [
			'type' => 'hidden',
			'value' => $activityId
		]) ?>
		<h3><?= __d('buzz_photos', 'Select the location of your activity') ?>:</h3>

		<div class="spacer"></div>

		<div class="row">
			<?php
			$i = 0;
			foreach ($sites as $site):
				$class = ($i == 0 && ! empty($firstColClass) ? $firstColClass : $colClass);
				$path = $this->Img->path(
					$site['LogoImage'][0],
					['width' => 500, 'height' => 400]
				);
				?>
				<div class="<?= $class ?> text-center">
					<input type="radio" name="siteId" id="siteId<?= $site['Site']['id'] ?>"
						   value="<?= $site['Site']['id'] ?>"
						   class="location-radio">

					<label for="siteId<?= $site['Site']['id'] ?>"
						   class="location-label category category--fixed match-heights--child"
						   style="background-image: url('<?= $path ?>'">
						<div class="category__content">
							<h3><?= $this->I18n->translate($site, 'Site.name') ?></h3>
						</div>
					</label>
				</div>
				<?php $i++; ?>
			<?php endforeach; ?>
		</div>
		<div class="spacer"></div>

		<div class="photo-module__actions">
			<div class="row">
				<div class="col-xs-6">
					<?= $this->Html->link(
						__d('buzz_photos', 'Back'),
						[
							'plugin' => 'buzz_photos',
							'controller' => 'activity_groups',
							'action' => 'index'
						],
						[
							'class' => 'button button--light background--septenary left'
						]
					); ?>
					<div class="spacer"></div>
				</div>
			</div>
		</div>

	</form>

<?php
$this->start('script');
echo $this->Html->script('BuzzPhotos.photos');
$this->end();
