<?php
$this->extend('/Common/view');
$title = __d('buzz_photos', 'Find your activity images');

if (! empty($data['Page']['title'])):
	$title = $data['Page']['title'];
endif;

$this->assign('title', $title);
?>

<div class="photo-module">
	<?php if (! empty($data['Page'])): ?>
		<?=$data['Page']['body']?>
	<?php endif; ?>

	<h3><?php echo __d('buzz_photos', 'Select the activity you took part in:'); ?></h3>

	<div class="spacer--1"></div>

	<div class="row">
		<div class="col-lg-10 col-lg-push-1">
			<div class="row" data-match-heights-of='[".category__content"]'>

				<?php foreach ($activities as $activity): ?>
					<div class="col-xs-6 col-sm-3 col-md-1_5 col-lg-1_5">
						<a class="category category--border<?php
							if (!empty($activity['ActivityGroup']['theme_id'])) {
								echo " theme--" . $activity['ActivityGroup']['theme_id'];
							}
						?>" href="<?php echo $this->Html->url([
							'plugin' => 'buzz_photos',
							'controller' => 'activity_groups',
							'action' => 'location',
							$activity['ActivityGroup']['id']]);
						?>">
							<?php
								$img = (empty($activity['Image'][0])) ? '/img/no-image.png' : $activity['Image'][0];

								echo $this->Image->resize($img, [
									'width' => 170,
									'height' => 140,
									'crop' => true
								]);
							?>
							<div class="category__content">
								<div>
									<h3><?php echo $this->I18n->translate($activity, 'ActivityGroup.name'); ?><i class="fa fa-chevron-circle-right fa-inline"></i></h3>
								</div>
							</div>
						</a>
						<div class="content__spacer"></div>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
	</div>
</div>

<?php
$this->start('script');
	echo $this->Html->script('BuzzPhotos.photos');
$this->end();
