<?php
App::uses('BuzzSourceAppModel', 'BuzzSource.Model');

class PhotoApi extends BuzzSourceAppModel {

	public function __construct($id = false, $table = null, $ds = null) {
		parent::__construct($id, $table, $ds);

		if (CakePlugin::loaded('BuzzSites')) {
			$Site = ClassRegistry::init('BuzzSites.Site');
			ConnectionManager::create('imageApi', $Site->getActiveSiteConfig('imageApi'));
			$this->useDbConfig = 'imageApi';
		} else {
			die('Unable to find BuzzSites plugin. This is a requirement for all sites.');
		}

		$this->dataSource = ConnectionManager::getDataSource('imageApi');
	}

	public function getTimes($applicationId, $date) {
		if (empty($applicationId) || empty($date)) {
			return false;
		}

		$result = $this->find('all', array(
			'method' => 'GetAlbumListByDate',
			'conditions' => array(
				'applicationId' => $applicationId,
				'activitydate' => $date
			)
		));

		return !empty($result['PhotoApi']['d']) ? $result['PhotoApi']['d'] : false;
	}

	public function getAlbum($albumId) {
		if (empty($albumId) || ! is_numeric($albumId)) {
			return false;
		}

		$result = $this->find('all', array(
			'method' => 'GetAlbumById',
			'conditions' => array(
				'albumId' => $albumId
			)
		));

		return !empty($result['PhotoApi']['d']) ? $result['PhotoApi']['d'] : false;
	}

/**
 * Get photos for a customer using their email address
 *
 * @param int $applicationId Application ID
 * @param string $email Customer's email address
 * @return array|bool
 */
	public function getCustomerPhotos($applicationId, $email) {
		$results = $this->find('all', [
			'method' => 'GetCustomerPhotos',
			'conditions' => [
				'applicationId' => $applicationId,
				'email' => trim($email),
			]
		]);

		return !empty($results['PhotoApi']['d']) ? ['Images' => $results['PhotoApi']['d']] : false;
	}

/**
 * getImage
 *
 * @param  string $imageId UUID of the image from the api
 * @return mixed Returns false or the api result
 */
	public function getImage($imageId) {
		if (empty($imageId)) {
			return false;
		}

		$result = $this->find('all', array(
			'method' => 'GetImageById',
			'conditions' => array(
				'Id' => $imageId
			)
		));

		return !empty($result['PhotoApi']['d']) ? $result['PhotoApi']['d'] : false;
	}

	/**
	 * Get a signed image url
	 *
	 * @param  string $imageId  UUID of the image from the api
	 * @return mixed Returns the URL or false
	 */
	public function getSignedImage($imageId) {
		if (empty($imageId)) {
			return false;
		}

		$result = $this->getImage($imageId);

		if (! empty($result['LargeKey'])) {
			$image = $result['LargeKey'];
			$image = 'http://' . str_replace('_large', '', $image); // Gets round the signed URL expiring after a week...

			return $image;
		}

		return false;
	}

}
