<?php
App::uses('BuzzPhotosAppModel', 'BuzzPhotos.Model');

class ActivityGroup extends BuzzPhotosAppModel {

	public $actsAs = array(
		'Routable.Routable' => array(
			'alias' => 'activity-photos/:displayField',
			'actual' => ':plugin/:controller/view/:primaryKey'
		),
		'MetaData.Meta',
		'BuzzTranslate.Translatable',
	);

	public $imageSlots = array(
		'main' => array(
			'slots' => 1,
			'fields' => array()
		),
		'feature' => array(
			'slots' => 1,
			'fields' => array()
		)
	);

/**
 * Validation rules
 * @var array
 */
	public $validate = array(
		'name' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'maxLength' => array(
				'rule' => array('maxLength', 150),
				'message' => 'No more than 150 characters'
			)
		),
		'stock_code' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			)
		),
	);

	public $hasMany = [
		'BuzzPhotos.ActivityGroupSite'
	];

/**
 * Query used to retrieve a record ready for edit
 *
 * @param int $id ID of row to edit
 * @param array $query The db query array - can be used to pass in additional parameters such as contain
 * @return array
 */
	public function readForEdit($id, $query = array()) {
		$query['contain'][] = 'ActivityGroupSite';
		return parent::readForEdit($id, $query);
	}

/**
 * Get an acitivity or fail
 *
 * @param int $activityId Activity ID
 * @param int $siteId Site ID
 * @return void
 * @throws NotFoundException
 */
	public function getActivityOrFail($activityId, $siteId) {
		$activity = $this->find('first', [
			'conditions' => [
				'id' => $activityId,
				'is_active' => 1
			],
			'contain' => [
				'Image',
				'ActivityGroupSite' => [
					'conditions' => [
						'site_id' => $siteId,
					]
				]
			]
		]);
		if (empty($activity)) {
			throw new NotFoundException;
		}

		return $activity;
	}
}
