<?php
class AddPhotosLookupToggleSiteSetting extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'Add_photos_lookup_toggle_site_setting';

	public function __construct($options = []) {
		parent::__construct($options);
		$this->SiteSetting = ClassRegistry::init('SiteSettings.SiteSetting');
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		$category = $this->SiteSetting->SiteSettingCategory->findByName('Photo Purchases');
		if (empty($category)) {
			return false;
		}

		if ($direction === 'up') {
			$this->SiteSetting->save([
				'label' => 'Photo Lookup',
				'name' => 'photo_lookup',
				'type' => 'select',
				'value' => 'by Date',
				'options' => implode("\n", [
					'by Date',
					'by Email',
				]),
				'sequence' => 10,
				'site_setting_category_id' => $category['SiteSettingCategory']['id'],
			]);

			return true;
		}

		$this->SiteSetting->deleteAll(['name' => 'photo_lookup']);

		return true;
	}
}
