<?php
class RemoveOldActivityGroupSiteIdAndApiKeyFields extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'remove_old_activity_group_site_id_and_api_key_fields';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'alter_field' => array(
				'buzz_photos_activity_group_sites' => array(
					'api_key' => array('type' => 'string', 'null' => true, 'default' => null, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
				),
			),
			'drop_field' => array(
				'buzz_photos_activity_groups' => array('api_key', 'stock_code'),
			),
		),
		'down' => array(
			'alter_field' => array(
				'buzz_photos_activity_group_sites' => array(
					'api_key' => array('type' => 'string', 'null' => true, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
				),
			),
			'create_field' => array(
				'buzz_photos_activity_groups' => array(
					'api_key' => array('type' => 'string', 'null' => true, 'default' => null, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'stock_code' => array('type' => 'string', 'null' => true, 'default' => null, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
				),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
