<?php
class AddNewSitesLinkerTable extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_new_sites_linker_table';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_table' => array(
				'buzz_photos_activity_group_sites' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'primary'),
					'activity_group_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'site_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'api_key' => array('type' => 'string', 'null' => true, 'default' => null, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
					'stock_code' => array('type' => 'string', 'null' => true, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_general_ci', 'engine' => 'InnoDB'),
				),
			),
		),
		'down' => array(
			'drop_table' => array(
				'buzz_photos_activity_group_sites'
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction == 'up') {
			$ActivityGroupModel = ClassRegistry::init('BuzzPhotos.ActivityGroup');
			$activityGroups = $ActivityGroupModel->find('all');

			$activityGroupSites = [];

			if (! empty($activityGroups)) {
				foreach ($activityGroups as $activityGroup) {
					$activityGroupSites[] = [
						'site_id' => 1,
						'activity_group_id' => $activityGroup['ActivityGroup']['id'],
						'api_key' => $activityGroup['ActivityGroup']['api_key'],
						'stock_code' => $activityGroup['ActivityGroup']['stock_code']
					];
				}
			}

			if (! empty($activityGroupSites)) {
				$ActivityGroupSitesModel = ClassRegistry::init('BuzzPhotos.ActivityGroupSite');
				$ActivityGroupSitesModel->saveMany($activityGroupSites);
			}
		} elseif ($direction == 'down') {
			$ActivityGroupSitesModel = ClassRegistry::init('BuzzPhotos.ActivityGroupSite');
			$ActivityGroupSites->deleteAll();
		}

		return true;
	}
}
