<?php
class AddPriceToSiteSettings extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'Add_price_to_site_settings';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			$Settings = ClassRegistry::init('SiteSettings.SiteSetting');
			$photoPrice = $Settings->findByName('photo_price');
			if (empty($photoPrice)) {
				$this->_seedPhotoPrice($Settings);
			}
		}
		return true;
	}

/**
 * Seed site settings with the Photo Price
 * @param object $Settings SiteSetting model
 * @return void
 */
	protected function _seedPhotoPrice($Settings) {
		$category = $Settings->SiteSettingCategory->findByName('Photo Purchases');
		if (! empty($category['SiteSettingCategory']['id'])) {
			$Settings->save([
				'label' => 'Photo Price',
				'name' => 'photo_price',
				'type' => 'integer',
				'value' => 0,
				'sequence' => 0,
				'site_setting_category_id' => $category['SiteSettingCategory']['id']
			]);
		}

		return;
	}
}
