<?php
class BuzzPhotosEmails extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzPhotos_emails';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			$EmailGroup = ClassRegistry::init('BuzzEmails.EmailGroup');
			$data = array(
				'name' => 'Photos'
			);
			$EmailGroup->save($data);
			$data = array(
				array(
					'name' => 'Activity Photos Order Confirmation',
					'system_name' => 'BuzzPhotos.confirmation_email',
					'email_group_id' => $EmailGroup->id,
					'subject' => 'Activity Photo Purchase Confirmation',
					'content' => '<p>Dear {fullName},</p><p>Thank you for your Activity Photo purchase. Below you will find your order details along with download links for each of your photographs.&nbsp;</p><p>You can also&nbsp;<a href="{orderUrl}">click here to view your order details</a>.</p><p>{==details==}</p>',
					'required_tokens' => '["==details==","fullName"]',
					'optional_tokens' => '["uuid","firstName","lastName","phone","email","billingAddress","totalPrice","date","time","orderUrl"]'
				),
				array(
					'name' => 'Activity Photos Order Notification',
					'system_name' => 'BuzzPhotos.notification_email',
					'email_group_id' => $EmailGroup->id,
					'subject' => 'A New Activity Photo Order has been placed',
					'content' => '<p>A new Activity Photo order has been placed by {fullName}.&nbsp;</p><p>Details of the order can be found below:</p><p>{==details==}</p><p>View Order Details: {adminUrl}</p>',
					'required_tokens' => '["==details==","fullName","adminUrl"]',
					'optional_tokens' => '["uuid","firstName","lastName","phone","email","billingAddress","totalPrice","date","time","orderUrl"]'
				),
			);
			ClassRegistry::init('BuzzEmails.Email')->saveMany($data);
		}

		return true;
	}
}
