<?php
class ChangedSiteSettingValuesToUseTranslatableStringsInstead extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'changed_site_setting_values_to_use_translatable_strings_instead';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		// Drop old site settings
		$SiteSetting = ClassRegistry::init('SiteSettings.SiteSetting');

		$SiteSetting->deleteAll(array(
			'SiteSetting.name' => array(
				'photo_share_facebook_title',
				'photo_share_facebook_description',
				'photo_share_page_body'
			)
		));

		$Strings = ClassRegistry::init('SiteSettings.CmsString');

		$Strings->saveMany(array(
			array(
				'name' => 'photo_share_facebook_title',
				'label' => 'Photo Share Facebook Title',
				'value' => 'Take a look at my experience photos!',
				'enable_html' => 0,
			),
			array(
				'name' => 'photo_share_facebook_description',
				'label' => 'Photo Share Facebook Description',
				'value' => 'I recently went to Twinwoods Adventure and had a great time. Click the photo to view my experience!',
				'enable_html' => 0,
			),
			array(
				'name' => 'photo_share_page_body',
				'label' => 'Photo Share Page Body',
				'value' => '',
				'enable_html' => 1,
			)

		), array('deep' => true));



		return true;
	}
}
