<?php
class DiscountCodeSupport extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'discount_code_support';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'buzz_photos_orders' => array(
					'sub_total' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '10,2', 'unsigned' => false, 'after' => 'billing_address'),
					'discount' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '10,2', 'unsigned' => false, 'after' => 'sub_total'),
					'discount_code' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 100, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4', 'after' => 'total_price'),
				),
			),
			'create_table' => array(
				'buzz_photos_photo_discount_types' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'primary'),
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'handler_slug' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 100, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'is_active' => array('type' => 'boolean', 'null' => true, 'default' => null),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_bin', 'engine' => 'InnoDB'),
				),
				'buzz_photos_photo_discounts' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'primary'),
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'code' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 100, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'photo_discount_type_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'value' => array('type' => 'float', 'null' => true, 'default' => null, 'length' => '10,2', 'unsigned' => false),
					'start_date' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'end_date' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'discount_items' => array('type' => 'boolean', 'null' => true, 'default' => null),
					'is_active' => array('type' => 'boolean', 'null' => true, 'default' => null),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_bin', 'engine' => 'InnoDB'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'buzz_photos_orders' => array('sub_total', 'discount', 'discount_code'),
			),
			'drop_table' => array(
				'buzz_photos_photo_discount_types', 'buzz_photos_photo_discounts'
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction == 'up') {
			$Menu = ClassRegistry::init('Navigation.Menu');
			$menu = $Menu->find('first', array(
				'conditions' => array(
					'url' => '/admin/buzz_photos/activities'
				)
			));

			if (! empty($menu)) {
				$Menu->clear();

				$Menu->save(array(
					'parent_id' => $menu['Menu']['id'],
					'name' => 'Discount Codes',
					'url' => '/admin/buzz_photos/photo_discounts',
					'pattern' => '\/^\/admin\/buzz_photos\/photo_discounts\//',
					'icon' => 'money',
					'is_active' => 1
				), array('deep' => true));
			}

			$DiscountType = ClassRegistry::init('BuzzPhotos.PhotoDiscountType');
			$DiscountType->saveMany(array(
				array(
					'name' => 'Percentage Discount',
					'handler_slug' => 'percent',
					'is_active' => 1
				),
				array(
					'name' => 'Fixed Price',
					'handler_slug' => 'fixed',
					'is_active' => 1
				),
				array(
					'name' => 'Cash Discount',
					'handler_slug' => 'cash',
					'is_active' => 1
				)
			), array('deep' => true));
		}

		return true;
	}
}
