<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_photos', 'Checkout'));
?>


<div class="content__spacer"></div>

<?php echo $this->element('BuzzPhotos.basket_preview'); ?>
<?php echo $this->Form->create(null); ?>
<div class="row">
	<div class="col-xs-12">
		<div class="outline--septenary outline--thin background--white padding-gutters-1_2 basket">
			<h3><?=__d('buzz_photos', 'Discount Code')?></h3>
			<p><?=__d('buzz_photos', 'If you have a discount code, you may enter it below to apply it to your order.')?></p>

			<div class="row">
				<div class="col-xs-12 col-sm-4 col-md-3">
					<?php echo $this->Form->addField('discount_code', array(
						'label' => false,
						'type' => 'string',
						'value' => (! empty($data['Photo']['discount_code']) ? $data['Photo']['discount_code'] : null)
					)); ?>
				</div>
				<div class="col-xs-12 col-sm-4 col-md-3">
					<?php echo $this->Form->button(__d('buzz_photos', 'Apply Discount'), ['class' => 'button']); ?>
				</div>
			</div>
		</div>
	</div>
</div>
<?php echo $this->Form->end(); ?>

<div class="content__spacer"></div>

<?php echo $this->Form->create(null, ['class' => 'validate']); ?>

<div class="row">
	<div class="col-xs-12">
		<?php if ($order['Order']['total_price'] > 0): ?>
			<h2><?php echo __d('buzz_photos', 'Please enter your billing and payment details'); ?></h2>
		<?php else: ?>
			<h2><?php echo __d('buzz_photos', 'Please enter your contact details'); ?></h2>
		<?php endif; ?>
	</div>
</div>

<div class="row">
	<div class="col-xs-12 col-md-6">
		<?php if ($order['Order']['total_price'] > 0): ?>
			<h3><?php echo __d('buzz_photos', 'Billing details'); ?></h3>
			<div class="form--side-labels form--compact validate">
				<?php
				$model = !empty($model) ? $model : 'CustomerAddress';

				echo $this->Form->input($model . '.first_name', [
					'label' => __d('buzz_photos', 'First name'),
					'class' => 'required',
					'div' => 'required input'
				]);
				echo $this->Form->input($model . '.last_name', [
					'label' => __d('buzz_photos', 'Last name'),
					'class' => 'required',
					'div' => 'required input'
				]);
				echo $this->Form->input($model . '.address_line_1', [
					'label' => __d('buzz_photos', 'Address'),
					'class' => 'required',
					'div' => 'required input'
				]);
				echo $this->Form->input($model . '.address_line_2', [
					'label' => __d('buzz_photos', 'Address Line 2'), 'div' => 'input input--displace-label',
				]);
				echo $this->Form->input($model . '.city', [
					'label' => __d('buzz_photos', 'Town/City'),
					'class' => 'required',
					'div' => 'required input'
				]);
				echo $this->Form->input($model . '.country_id', [
					'label' => __d('buzz_photos', 'Country'),
					'div' => 'input select js-country required',
					'class' => 'required',
				]);
				echo $this->Form->input($model . '.us_state_id', [
					'label' => __d('buzz_photos', 'State'),
					'div' => 'input select js-us-state required',
					'class' => 'required'
				]);

				echo $this->Form->input($model . '.postcode', [
					'label' => __d('buzz_photos', 'Postcode'),
					'div' => 'input js-postcode required',
					'class' => 'text-uppercase required'
				]);
				?>

				<?php echo $this->Form->input('CustomerAddress.telephone', [
					'label' => __d('buzz_photos', 'Telephone'),
					'class' => 'required',
					'div' => 'required input'
				]); ?>
				<?php echo $this->Form->input('CustomerAddress.email', [
					'label' => __d('buzz_photos', 'Email'),
					'class' => 'required',
					'div' => 'required input'
				]); ?>
			</div>
		<?php else: ?>
			<h3><?php echo __d('buzz_photos', 'Contact details'); ?></h3>
			<div class="form--side-labels form--compact validate">
				<?php echo $this->Form->input('CustomerAddress.first_name', ['label' => __d('buzz_photos', 'First name')]); ?>
				<?php echo $this->Form->input('CustomerAddress.last_name', ['label' => __d('buzz_photos', 'Last name')]); ?>
				<?php echo $this->Form->input('CustomerAddress.telephone', ['label' => __d('buzz_photos', 'Telephone')]); ?>
				<?php echo $this->Form->input('CustomerAddress.email', ['label' => __d('buzz_photos', 'Email')]); ?>
			</div>
		<?php endif; ?>
	</div>
	<div class="col-xs-12 col-md-6">
		<?php if (Configure::read('BuzzPurchase.onsite') === true && $order['Order']['total_price'] > 0): ?>
			<h3><?php echo __d('buzz_photos', 'Payment details'); ?></h3>
			<div class="form--side-labels form--compact validate">
				<?php echo $this->element('BuzzPurchase.Forms/payment_form'); ?>
			</div>
			<div class="content__spacer">&nbsp;</div>
		<?php endif; ?>

	</div>
</div>

<div class="booking__actions">
	<div class="row">
		<div class="col-xs-6">
			<?php echo $this->Html->link(__d('buzz_photos', 'Back'), $previousStep, ['class' => 'button button--light background--septenary left']); ?>
		</div>

		<div class="col-xs-6">
			<?php if ($order['Order']['total_price'] > 0): ?>
				<?php echo $this->Form->button(__d('buzz_photos', 'Pay Now') . '<i class="fa fa-credit-card fa-inline"></i>', ['class' => 'button button--dark background--senary right button--booking-proceed']); ?>
			<?php else: ?>
				<?php echo $this->Form->button(__d('buzz_photos', 'Complete Booking'), ['class' => 'button button--dark background--senary right']); ?>
			<?php endif; ?>
		</div>
	</div>
</div>

<?php echo $this->Form->end(); ?>
