<div class='edit-form'>

	<div class='edit-form__header'>
		<h1 class='title'><?php echo $this->InflectorExt->camelToPluralize($displayName); ?> <span>Administration</span></h1>
		<h2 class='title edit-form__title'>
			<?php
				if (isset($title_for_layout)):

					echo $title_for_layout;

				else:

					echo $this->InflectorExt->camelToHumanize(preg_replace('|^admin_|i', '', $this->request->action));
					echo $this->InflectorExt->camelToHumanize($displayName);

				endif;
			?>
		</h2>

		<?php echo $this->Element('toolbar'); ?>
	</div>

	<?php

		echo $this->Html->script('admin_form', array('inline'=>false));

		echo $this->Form->create($primaryModel, array(
			'inputDefaults'=>array(
				'empty'=>''
			),
			'type' => 'file',
			'class' => 'cr'
		));

	?>

	<div class='tab__content' data-title='Order Details'>
		<?php echo $this->Element('Forms/view_fields', array('fields' => $fields)); ?>
	</div>


	<?php if (! empty($this->request->data['OrderItem'])): ?>
		<div class="tab__content" data-title="Photos Ordered">
			<table class="table">
				<thead>
					<tr>
						<th><?=__d('buzz_photos', 'Photo')?></th>
						<th><?=__d('buzz_photos', 'Unique Identifier')?></th>
						<th><?=__d('buzz_photos', 'Price')?></th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ($this->request->data['OrderItem'] as $item): ?>
						<tr>
							<td><?=$this->Html->image($item['thumb_url'], array('style' => 'max-height:150px;'))?></td>
							<td><?=$item['uuid']?></td>
							<td><?=$this->Number->currency($item['unit_price'])?></td>
						</tr>
					<?php endforeach; ?>
				</tbody>
			</table>
		</div>
	<?php endif; ?>

	<?php if (! empty($transaction)): ?>
		<div class="tab__content" data-title="Transaction">

			<div class="preview">
				<h3><?=__d('buzz_photos', 'Transaction')?> #<?php echo $transaction['Transaction']['id']; ?></h3>

				<dl class="transactions_details">

					<dt><?=__d('buzz_photos', 'Transaction Date')?>:</dt>
					<dd><?php echo $this->Time->format('jS M Y, g:ia', $transaction['Transaction']['created']); ?></dd>

					<dt><?=__d('buzz_photos', 'Transaction Amount')?>:</dt>
					<dd>&pound;<?php echo $transaction['Transaction']['transaction_amount']; ?></dd>

				</dl>

				<h2><?=__d('buzz_photos', 'Transaction Items')?></h2>

				<dl class="transactions_details items">

					<?php if (! empty($transaction['TransactionsItem'])): ?>
						<?php foreach ($transaction['TransactionsItem'] as $item): ?>

							<dt>&pound;<?php echo number_format($item['amount'], 2); ?></dt>
							<dd><?php echo $item['description']; ?></dd>

						<?php endforeach; ?>
					<?php endif; ?>

				</dl>
			</div>


		</div>
	<?php endif; ?>

</div>