<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_photos', 'Find your activity images'));
?>

<div class="photo-module" data-activityid="<?=$data['ActivityGroup']['id']?>">

	<form>
		<h3><?=__d('buzz_photos', 'Select the date that you did the activity')?>:</h3>

		<div class="spacer"></div>

		<div class="row">
			<div class="col-xs-12 col-sm-6">

				<div class="text-center">
					<div class="input">

						<input id="datepicker-date" type="hidden" class="datepicker-hidden-field" />
					</div>
					<div class="datepicker inline-block" data-max-date="<?=Date('Y-m-d')?>"></div>
				</div>
			</div>
			<div class="col-xs-12 col-sm-6">
				<?php if (! empty($data['FeatureImage'][0])): ?>
					<?=$this->Image->resize($data['FeatureImage'][0], array(
						'width' => 700,
						'class' => 'img-responsive'
					))?>
				<?php endif; ?>
			</div>
		</div>

		<div class="spacer--2"></div>

		<h3><?=__d('buzz_photos', 'Select the time that you did the activity')?>:</h3>

		<div class="spacer"></div>

		<div class="activity-date-selector"></div>

		<div class="times"></div>

		<div class="spacer"></div>

		<div class="photo-module__actions">
			<div class="row">
				<div class="col-xs-6">
					<?=$this->Html->link(
						'Go Back',
						array(
							'plugin' => 'buzz_photos',
							'controller' => 'activity_groups',
							'action' => 'index'
						),
						array(
							'class' => 'photo-module__button--back'
						)
					); ?>
					<div class="spacer"></div>
				</div>

				<div class="col-xs-6 text-right">
					<?=$this->Form->button('Proceed', [
						'class' => 'photo-module__button--proceed process-date',
						'disabled' => true
					]); ?>
				</div>
			</div>
		</div>

	</form>

</div>

<?php
$this->start('script');
	echo $this->Html->script('BuzzPhotos.photos');
$this->end();