<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_photos', 'Share Image'));
?>

<div class="row">
	<div class="col-xs-12 col-sm-6 text-center">
		<?php echo $this->Html->image('http://' . $image['MediumKey'], array('class' => 'img-responsive'))?>
	</div>
	<div class="col-xs-12 col-sm-6">
		<h1><?=__d('buzz_photos', 'Event on %s', $date)?></h1>

		<div class="row">
			<div class="col-xs-12 col-sm-6">
				<div class="fb-share-button" data-href="<?=$this->here?>" data-layout="button" data-size="large" data-mobile-iframe="true"><a class="fb-xfbml-parse-ignore" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fdevelopers.facebook.com%2Fdocs%2Fplugins%2F&amp;src=sdkpreparse">Share</a></div>
			</div>
			<div class="col-xs-12 col-sm-6 text-right">
				<?=$this->Html->link('View &amp; Purchase From Album', array(
					'admin' => false,
					'plugin' => 'buzz_photos',
					'controller' => 'activity_groups',
					'action' => 'album',
					$image['AlbumId']
				), array(
					'class' => 'button',
					'escape' => false
				))?>
			</div>
		</div>

		<hr>
		<?=$this->I18n->translate(Configure::read('String.photo_share_page_body'), 'value')?>

	</div>
</div>

<?php

$this->start('meta');
?>
	<meta property="og:title" content="<?=$this->I18n->translate(Configure::read('String.photo_share_facebook_title'), 'value')?>">
	<meta property="og:image" content="http://<?=$image['MediumKey']?>">
	<meta property="og:type" content="website">
	<meta property="og:url" content="<?=Router::url( $this->here, true )?>">
	<meta property="og:description" content="<?=$this->I18n->translate(Configure::read('String.photo_share_facebook_description'), 'value')?>">
<?php
$this->end();