<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_photos', 'Find your activity images'));
?>

<div class="photo-module">
	<h3><strong><?=__d('buzz_photos', 'Experience Date:')?></strong> <?=$date?></h3>
	<h3><?=__d('buzz_photos', 'Please select your images:')?></h3>

	<p><?=__d('buzz_photos', 'Add multiple images to your basket, or click on individual images to view a larger proof.')?></p>

	<?php
	echo $this->Form->create(
		null,
		array(
			'url' => array(
				'plugin' => 'buzz_photos',
				'controller' => 'orders',
				'action' => 'add'
			)
		)
	);

	?>
		<div class="row">
			<div class="col-xs-12 col-lg-7 col-lg-push-5 text-center lg-text-right">
				<?php
					echo $this->Html->link(
						__d('buzz_photos', 'Play Slideshow'),
						'#',
						[
							'class' => 'photo-module__button--play-slideshow',
							'data-toggle' => 'modal',
							'data-target' => '#slideshowModal',
							'style' => 'display:none'
						]
					);
				?>

				<?=$this->Form->button(__d('buzz_photos', 'Buy Selected'), [
					'class' => 'photo-module__button button photo-module__buy-button',
					'type' => 'submit',
					'disabled' => true
				]); ?>
			</div>

			<div class="col-xs-12 col-lg-5 col-lg-pull-7">
				<?php
					echo $this->Form->input(
						'select_all_images',
						array(
							'id' => 'image_checkbox',
							'label' => __d('buzz_photos', 'Select all images from this session'),
							'div' => array(
								'class' => 'checkbox--custom checkbox--left checkbox--small'
							),
							'type' => 'checkbox',
							'class' => 'js-select-all'
						)
					);
				?>
			</div>
		</div>

		<div class="modal fade modal--photo-module" id="slideshowModal" tabindex="-1" role="dialog">
			<div class="modal-dialog" role="document">
				<div class="modal-content">
					<div class="container-fluid">
						<div class="row">
							<div class="col-xs-12">
								<div class="modal-header">
									<span class="modal__button modal__close" data-dismiss="modal" aria-label="<?=__d('buzz_photos', 'Close')?>"><?=__d('buzz_photos', 'Close')?> <i class="fa fa-times"></i></span>
									<h2><?=__d('buzz_photos', 'Image Slideshow')?></h2>
								</div>

								<div class="modal-body">
									<div class="gallery gallery--border gallery--arrows gallery--slideshow" style="display:none">
										<?php $i = 0; ?>
										<?php foreach ($activities as $image): ?>
											<?php if (!empty($image['PreviewImage']['filename'])): ?>
												<?php $i++; ?>
												<div>
													<?php echo $this->Html->image($image['PreviewImage']['filepath'], ['width' => 800, 'height' => 432, 'alt' => '#' . $i]); ?>
													<div class="slide__caption text-center"><?=__d('buzz_photos', 'Photo')?> #<?=$i?></div>
													</div>
											<?php endif; ?>
										<?php endforeach; ?>
									</div>

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<hr />

		<div class="row">
			<?php $count = 0; ?>
			<?php foreach($activities as $activity): ?>
				<?php $count++; ?>
				<div class="col-xs-6 col-sm-3 col-md-1_5">
					<?php
						$imagePath = $activity['PreviewImage']['filepath'];
						$imageElement = $this->Html->image($activity['Image']['filepath'], [
							'width' => 200,
							'height' => 130,
							'crop' => true,
						]);
						echo $this->Html->link(
							$imageElement,
							$imagePath,
							[
								'class' => 'magnific-popup photo-module__image',
								'escape' => false
							]
						);
					?>
					<div class="row">
						<div class="col-xs-6">
							<?php
								echo $this->Form->input(
									'image_checkbox.',
									array(
										'id' => 'image_checkbox',
										'label' => $count,
										'div' => array(
											'class' => 'checkbox--custom checkbox--left checkbox--small'
										),
										'type' => 'checkbox',
										'class' => 'js-select-all-selectable',
										'value' => $activity['Image']['id']
									)
								);
							?>
						</div>

						<div class="col-xs-6 text-right gutterless--left">
						<?php
							$imageUrl = Router::url(array(
								'admin' => false,
								'plugin' => 'buzz_photos',
								'controller' => 'activity_groups',
								'action' => 'share',
								$activity['Image']['id']
							), true);
							?>

							<?php /** Facebook Share Image **************************/ ?>
								<div id="fb-root"></div>
								<div class="fb-share-button" data-href="<?=$imageUrl?>" data-layout="button" data-size="large" data-mobile-iframe="false"><a class="fb-xfbml-parse-ignore" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?=urlencode($imageUrl)?>"><?=__d('buzz_photos', 'Share')?></a></div>
							<?php /**************************************************/ ?>
						</div>
					</div>

					<div class="spacer--1"></div>
				</div>
			<?php endforeach; ?>
		</div>

		<div class="spacer--1"></div>

		<div class="photo-module__actions">
			<div class="row">
				<div class="col-xs-6">
					<?=$this->Html->link(
						'Go Back',
						array(
							'plugin' => 'buzz_photos',
							'controller' => 'activity_groups',
							'action' => 'index'
						),
						array(
							'class' => 'photo-module__button--back'
						)
					); ?>
					<div class="spacer"></div>
				</div>

				<div class="col-xs-6 text-right">
					<?=$this->Form->button(__d('buzz_photos', 'Buy Selected'), [
						'class' => 'photo-module__button button photo-module__buy-button',
						'type' => 'submit',
						'disabled' => true
					]); ?>
				</div>
			</div>
		</div>
	<?=$this->Form->end()?>
</div>

<?php
$this->start('script');
	echo $this->Html->script('BuzzPhotos.photos');
$this->end();
