<?php
App::uses('BuzzSourceAppModel', 'BuzzSource.Model');

class PhotoApi extends BuzzSourceAppModel {

	public function __construct($id = false, $table = null, $ds = null) {
		parent::__construct($id, $table, $ds);

		$this->useDbConfig = 'imageApi';
		$this->dataSource = ConnectionManager::getDataSource($this->useDbConfig);
	}

	public function getTimes($applicationId, $date) {
		if (empty($applicationId) || empty($date)) {
			return false;
		}

		$result = $this->find('all', array(
			'method' => 'GetAlbumListByDate',
			'conditions' => array(
				'applicationId' => $applicationId,
				'activitydate' => $date
			)
		));

		return !empty($result['PhotoApi']['d']) ? $result['PhotoApi']['d'] : false;
	}

	public function getAlbum($albumId) {
		if (empty($albumId)) {
			return false;
		}

		$result = $this->find('all', array(
			'method' => 'GetAlbumById',
			'conditions' => array(
				'albumId' => $albumId
			)
		));

		return !empty($result['PhotoApi']['d']) ? $result['PhotoApi']['d'] : false;
	}

	public function getImage($imageId) {
		if (empty($imageId)) {
			return false;
		}

		$result = $this->find('all', array(
			'method' => 'GetImageById',
			'conditions' => array(
				'Id' => $imageId
			)
		));

		return !empty($result['PhotoApi']['d']) ? $result['PhotoApi']['d'] : false;
	}

	public function getSignedImage($imageId) {
		if (empty($imageId)) {
			return false;
		}

		$result = $this->find('all', array(
			'method' => 'GenerateImageSignedURLS',
			'conditions' => array(
				'images' => $imageId
			)
		));

		return !empty($result['PhotoApi']['d']) ? $result['PhotoApi']['d'] : false;
	}

}