<?php
App::uses('BuzzPhotosAppModel', 'BuzzPhotos.Model');

class Order extends BuzzPhotosAppModel {

/**
 * Behaviors
 *
 * @var array
 */
	public $actsAs = array(
		'BuzzPurchase.Payable'
	);

	public $hasMany = array(
		'OrderItem' => array(
			'className' => 'BuzzPhotos.OrderItem',
			'foreignKey' => 'order_id',
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'dependent' => true
		)
	);

	public $virtualFields = array(
		'full_name' => 'CONCAT(Order.first_name, " ", Order.last_name)'
	);

	public function readForEdit($id, $query = array()) {
		$query['contain'][] = 'OrderItem';

		return parent::readForEdit($id, $query);
	}

/**
 * Clear old incomplete orders from the db
 *
 * @return void
 */
	public function clearOldOrders() {
		// Only delete if they have been left unpaid and untouched for over 2 weeks
		$date = new DateTime();
		$date->sub(new DateInterval('P14D'));
		$date = $date->format('Y-m-d H:i:s');

		$this->deleteAll(array(
			'is_paid' => 0,
			'modified < ' => $date
		));
	}

/**
 * Complete the purchase
 *
 * @param bool $paid True if payment successfully made
 * @return bool
 */
	public function completePurchase($id, $paid) {
		$order = $this->findById($id);

		$response = true;

		if ((int)$order['Order']['is_paid'] === 0) {
			if ($paid === true) {
				$order['Order']['is_paid'] = '1';
				$result = $this->save($order, ['deep' => true]);
			}

			// Clear the basket session.
			$this->clearOrderId();

			// Raise an event when purchase is complete. This will be used for
			// triggering the sending of confirmation emails (etc.).
			$Event = new CakeEvent('BuzzPhotos.Model.Order.completed', $this, array(
				'id' => $this->id
			));
			$this->getEventManager()->dispatch($Event);
		}

		return $response;
	}

/**
 * Clear the sessions
 * @return void
 */
	public function clearOrderId() {
		CakeSession::delete('photoOrderId');
		CakeSession::delete('photoOrderUuid');
	}
}