<?php
$libPath = App::pluginPath('BuzzPhotos') . 'Lib' . DS;

// Yes, this is actually the correct way to do this in cake. App::import is discouraged from use if its not a vendor package, which its not.
require_once ($libPath . 'DiscountModifiers' . DS . 'FixedAmountModifier.php');
require_once ($libPath . 'DiscountModifiers' . DS . 'PercentageModifier.php');
require_once ($libPath . 'DiscountModifiers' . DS . 'CashDiscountModifier.php');

class Discount {

	public $discount;

	public $priceModifier;

	public $basket;

	public $discountCode;

	public function __construct($discountCode, $basket) {
		$DiscountModel = ClassRegistry::init('BuzzPhotos.PhotoDiscount');
		$discount = $DiscountModel->find('first', array(
			'conditions' => array(
				'PhotoDiscount.code' => $discountCode,
				'PhotoDiscount.is_active' => 1
			),
			'contain' => array(
				'PhotoDiscountType'
			)
		));

		if (empty($discount)) {
			return false;
		}

		$this->discount = $discount;
		$this->discountCode = $discountCode;
		$this->basket = $basket;

		$this->priceModifier = new Evoluted\PriceModifier\PriceModifier(
			new Evoluted\PriceModifier\Basket\Basket(new Evoluted\PriceModifier\Storage\Session, '1')
		);
	}

	public function applyDiscount() {
		// Work out if the code is valid (E.g it might be expired)
		if (empty($this->discount)) {
			return false;
		}

		if (strtotime($this->discount['PhotoDiscount']['start_date']) > time()) {
			// Code isnt active yet
			return false;
		}

		if (strtotime($this->discount['PhotoDiscount']['end_date']) < time()) {
			// Code has expired
			return false;
		}

		$this->__populateBasket();

		// Add discount rules
		$this->__addDiscountRules();

		// Add out discount data to the basket (custom implementation)
		$this->priceModifier->basket()->discountData = $this->discount;

		// Apply discounts
		$this->priceModifier->applyDiscounts();

		// Only return the discount amount.
		$data = $this->priceModifier->basket()->toArray();

		if (! empty($data['discount'])) {
			CakeSession::write('photoDiscountCode', $this->discountCode);
			return number_format($data['discount'], 2);
		}

		return false;
	}

	private function __addDiscountRules() {
		$discount = $this->discount;

		if (! empty($this->discount['PhotoDiscountType']['handler_slug'])
			&& $this->discount['PhotoDiscountType']['handler_slug'] == 'percent') {
			$this->priceModifier->addDiscountModifier('percentageDiscount', 'Evoluted\BuzzPhotos\DiscountModifiers\PercentageModifier');

			// Deduct a fixed amount from basket
			$this->priceModifier->addDiscountRule([
				'id' => 'percentageDiscount',
				'discountType' => 'percentageDiscount',
				'amount' => $discount['PhotoDiscount']['value'],
				'applyToItems' => ($discount['PhotoDiscount']['discount_items'] == '1' ? true : false)
			]);
		} elseif (! empty($this->discount['PhotoDiscountType']['handler_slug'])
			&& $this->discount['PhotoDiscountType']['handler_slug'] == 'fixed') {
			// Add the discount modifier
			$this->priceModifier->addDiscountModifier('fixedAmount', 'Evoluted\BuzzPhotos\DiscountModifiers\FixedAmountModifier');

			// Modify the item totals of a row to a fixed amount
			$this->priceModifier->addDiscountRule([
				'id' => 'fixedAmount',
				'discountType' => 'fixedAmount',
				'amount' => $discount['PhotoDiscount']['value'],
				'applyToItems' => ($discount['PhotoDiscount']['discount_items'] == '1' ? true : false)
			]);
		} elseif (! empty($this->discount['PhotoDiscountType']['handler_slug'])
			&& $this->discount['PhotoDiscountType']['handler_slug'] == 'cash') {
			// Add the discount modifier
			$this->priceModifier->addDiscountModifier('cashDiscount', 'Evoluted\BuzzPhotos\DiscountModifiers\CashDiscountModifier');

			// Modify the item totals of a row to a fixed amount
			$this->priceModifier->addDiscountRule([
				'id' => 'cashDiscount',
				'discountType' => 'cashDiscount',
				'amount' => $discount['PhotoDiscount']['value'],
				'applyToItems' => ($discount['PhotoDiscount']['discount_items'] == '1' ? true : false)
			]);
		}
	}

	private function __populateBasket() {
		$basketData = array(
			'id' => $this->basket['Order']['id'],
			'items' => array(),
			'subtotal' => $this->basket['Order']['total_price']
		);

		foreach ($this->basket['OrderItem'] as $item) {
			$ref = 'OrderItem.' . $item['id'];

			$itemExtra = array(
				'reference' => $ref,
				'amount' => $item['unit_price']
			);

			$basketData['items'][] = array_merge($item, $itemExtra);
		}

		$this->priceModifier->basket()->populate($basketData);
	}

}
