<?php

class ActivityGroupsController extends BuzzPhotosAppController {

	public function beforeFilter() {
		parent::beforeFilter();
		$this->Auth->allow(array(
			'index',
			'view',
			'ajax_get_times',
			'album',
			'share'
		));
	}

	protected function _adminPopulateLookups() {
		parent::_adminPopulateLookups();
		$this->set('themes', array(1, 2, 3, 4));
	}

	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();
		$fields['ActivityGroup.theme_id']['empty'] = false;

		return $fields;
	}

	public function index() {
		if (Configure::read('BuzzPhotos.photos_page_id') > 0) {
			$this->assignPage(Configure::read('BuzzPhotos.photos_page_id'));
		}

		$activities = $this->{$this->modelClass}->find('all', array(
			'conditions' => array(
				'is_active' => 1
			),
			'contain' => array(
				'Image'
			)
		));
		$this->Meta->canonical(['action' => 'index']);
		$this->set('activities', $activities);
	}

	public function view($id) {
		$activity = $this->{$this->modelClass}->find('first', array(
			'conditions' => array(
				'id' => $id
			),
			'contain' => array(
				'FeatureImage'
			)
		));

		if (empty($activity)) {
			throw new NotFoundException;
		}
		$this->Meta->canonical(['action' => 'view', $id]);
		$this->set('data', $activity);
	}

	public function album($id) {
		$this->loadModel('BuzzPhotos.PhotoApi');
		$album = $this->PhotoApi->getAlbum($id);

		if (empty($album['Images'])) {
			return new NotFoundException;
		}

		$date = $this->_extractDate($album['AlbumDate']);

		$activities = array();

		foreach ($album['Images'] as $key => $image) {
			$activities[$key]['Image'] = array(
				'filename' => 'image.jpg',
				'filepath' => 'http://' . $image['ThumbKey'],
				'id' => $image['Id'],
				'type' => ''
			);

			$activities[$key]['PreviewImage'] = array(
				'filename' => 'image.jpg',
				'filepath' => 'http://' . $image['MediumKey'],
				'id' => $image['Id'],
				'type' => ''
			);
		}
		$this->Meta->canonical(['action' => 'album', $id]);
		$this->set(compact('activities', 'date'));
	}

	public function ajax_get_times($id, $date) {
		$activity = $this->{$this->modelClass}->find('first', array(
			'conditions' => array(
				'id' => $id,
				'is_active' => 1
			),
			'contain' => array(
				'Image'
			)
		));

		if (empty($activity)) {
			throw new NotFoundException;
		}

		$this->loadModel('BuzzPhotos.PhotoApi');
		$data = $this->PhotoApi->getTimes($activity['ActivityGroup']['api_key'], $date);

		$this->set(compact('data'));
		$this->layout = 'ajax';
	}

	public function share($uuid) {
		$this->loadModel('BuzzPhotos.PhotoApi');
		$image = $this->PhotoApi->getImage($uuid);

		if (empty($image)) {
			return new NotFoundException;
		}

		$album = $this->PhotoApi->getAlbum($image['AlbumId']);

		// Extract and format the date
		$date = $this->_extractDate($album['AlbumDate']);

		$this->set(compact('image', 'album', 'date'));
	}

	private function _extractDate($date) {
		$date = ltrim($date, '/Date(');
		$date = substr($date, 0, strpos($date, "+"));
		$date = $date / 1000;
		$date = date('jS F Y', $date);

		return $date;
	}

}
