<?php
class InitialBuzzPhotosMigration extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'initial_buzz_photos_migration';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_table' => array(
				'buzz_photos_activities' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'primary'),
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 150, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'api_key' => array('type' => 'string', 'null' => true, 'default' => null, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'theme_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'is_active' => array('type' => 'boolean', 'null' => true, 'default' => null),
					'sequence' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_bin', 'engine' => 'InnoDB'),
				),
				'buzz_photos_order_items' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'uuid' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 36, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'thumb_url' => array('type' => 'text', 'null' => true, 'default' => null, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'order_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false, 'key' => 'index'),
					'unit_price' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '10,2', 'unsigned' => false),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
						'fk_order_items__orders_idx' => array('column' => 'order_id', 'unique' => 0),
					),
					'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_bin', 'engine' => 'InnoDB'),
				),
				'buzz_photos_orders' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'uuid' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 36, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'first_name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 150, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'last_name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 150, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'phone' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'email' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'is_paid' => array('type' => 'boolean', 'null' => true, 'default' => null),
					'billing_address' => array('type' => 'text', 'null' => true, 'default' => null, 'collate' => 'utf8mb4_bin', 'charset' => 'utf8mb4'),
					'total_price' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '10,2', 'unsigned' => false),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_bin', 'engine' => 'InnoDB'),
				),
			),
		),
		'down' => array(
			'drop_table' => array(
				'buzz_photos_activities', 'buzz_photos_order_items', 'buzz_photos_orders'
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction == 'up') {
			$Settings = ClassRegistry::init('SiteSettings.SiteSetting');
			$SiteSettingCategory = ClassRegistry::init('SiteSettings.SiteSettingCategory');

			$SiteSettingCategory->save(array(
				'name' => 'Photo Purchases'
			), array('deep' => true));

			$categoryId = $SiteSettingCategory->id;

			$Settings->saveMany(array(
				array(
					'label' => 'Photo Share Facebook Title',
					'name' => 'photo_share_facebook_title',
					'type' => 'string',
					'value' => 'Take a look at my experience photos!',
					'sequence' => 1,
					'site_setting_category_id' => $categoryId
				),
				array(
					'label' => 'Photo Share Facebook Description',
					'name' => 'photo_share_facebook_description',
					'type' => 'string',
					'value' => 'I recently went to Twinwoods Adventure and had a great time. Click the photo to view my experience!',
					'sequence' => 2,
					'site_setting_category_id' => $categoryId
				),
				array(
					'label' => 'Photo Share Page Body',
					'name' => 'photo_share_page_body',
					'type' => 'html',
					'value' => '',
					'sequence' => 3,
					'site_setting_category_id' => $categoryId
				)

			), array('deep' => true));

			$Menu = ClassRegistry::init('Navigation.Menu');

			$Menu->save(array(
				'parent_id' => 1,
				'name' => 'Activity Photos',
				'url' => '/admin/buzz_photos/orders',
				'\/^\/admin\/buzz_photos\/orders\//',
				'icon' => 'image',
				'is_active' => 1
			), array('deep' => true));

			$menuId = $Menu->id;
			$Menu->clear();
			$Menu->save(array(
				'parent_id' => $menuId,
				'name' => 'Manage Activities',
				'url' => '/admin/buzz_photos/activities',
				'\/^\/admin\/buzz_photos\/activities\//',
				'icon' => 'image',
				'is_active' => 1
			), array('deep' => true));

		}

		return true;
	}
}
