function handleDateTimeSubmit() {
	var albumId = $(document).find('.radio-wrapper--selected input').val();
	var activityId = $(document).find('#ActivityGroupId').val();
	var albumUrl = '/activity-photos/album/' + activityId + '/' + albumId;

	window.location.href = albumUrl;
}

function selectTime(el) {
	var activity = $(el).val();
	$('.radio--photo-module').parent().removeClass('radio-wrapper--selected');
	$(el).parent().addClass('radio-wrapper--selected');

	$('.photo-module__button--proceed').prop('disabled', false);

}

function getActivityTimes() {
	var activityId = $('.photo-module').data('activityid');
	var dateString = $('#datepicker-date').val();

	var url = '/ajax/photo-activity-times/' + activityId + '/' + dateString;

	$('.times').load(url);
}

$(document).ready(function() {

	var dateString = $('input.datepicker-hidden-field');
	var $form = $('.photo-module');

	$form.on('change', 'input', function(){
		selectTime($(this));
	});

	var pageLoad = true;

	$(document).on('change', $('input.datepicker-hidden-field'), function(el){
		if ($('input.datepicker-hidden-field').val() != dateString) {
			dateString = $('input.datepicker-hidden-field').val()
			getActivityTimes();
		}
	});

	$('.photo-module__button--proceed').on('click touchend', function(e) {
		e.preventDefault();

		handleDateTimeSubmit();
	});

	$('form#ActivityGroupAlbumForm').on('change', 'input', function() {
		var $checkboxes = $('form#ActivityGroupAlbumForm').find('input[type=checkbox]');

		if ($checkboxes.filter(':checked').length > 0) {
			$('.photo-module__buy-button').prop('disabled', false);
		} else {
			$('.photo-module__buy-button').prop('disabled', true);
		}

	});
});

$(window).on("load", function (e) {
	$('.photo-module__button--play-slideshow').show();
});