<?php
App::uses('BuzzSourceAppModel', 'BuzzSource.Model');

class PhotoApi extends BuzzSourceAppModel {

	public function __construct($id = false, $table = null, $ds = null) {
		parent::__construct($id, $table, $ds);
		$this->useDbConfig = Configure::read('api.image') ?: 'imageApi';
	}

	public function getTimes($applicationId, $date) {
		if (empty($applicationId) || empty($date)) {
			return false;
		}

		$result = $this->find('all', array(
			'method' => 'GetAlbumListByDate',
			'conditions' => array(
				'applicationId' => $applicationId,
				'activitydate' => $date
			)
		));

		return !empty($result['PhotoApi']['d']) ? $result['PhotoApi']['d'] : false;
	}

	public function getAlbum($albumId) {
		if (empty($albumId)) {
			return false;
		}

		$result = $this->find('all', array(
			'method' => 'GetAlbumById',
			'conditions' => array(
				'albumId' => $albumId
			)
		));

		return !empty($result['PhotoApi']['d']) ? $result['PhotoApi']['d'] : false;
	}

	public function getImage($imageId) {
		if (empty($imageId)) {
			return false;
		}

		$result = $this->find('all', array(
			'method' => 'GetImageById',
			'conditions' => array(
				'Id' => $imageId
			)
		));

		return !empty($result['PhotoApi']['d']) ? $result['PhotoApi']['d'] : false;
	}

	public function getSignedImage($imageId) {
		if (empty($imageId)) {
			return false;
		}

		$result = $this->getImage($imageId);

		if (! empty($result['LargeKey'])) {
			$image = $result['LargeKey'];
			$image = 'http://' . str_replace('_large', '', $image); // Gets round the signed URL expiring after a week...

			return $image;
		}

		return false;
	}

}
