<?php

App::uses('CakeEventListener', 'Event');

class OrderListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'BuzzPhotos.Model.Order.completed' => 'confirmation'
		);
	}

	/**
	 * Send emails on confirmation of a photo order.
	 *
	 * @param CakeEvent $Event
	 * @return void
	 */
	public function confirmation(CakeEvent $Event) {
		$order = ClassRegistry::init('BuzzPhotos.Order')->find('first', array(
			'conditions' => array(
				'id' => $Event->data['id']
			),
			'contain' => array(
				'OrderItem'
			)
		));

		// Send confirmation email
		$this->_sendConfirmation($order);

		// Send staff notification email
		$this->_sendNotification($order);
		return;
	}

	protected function _sendNotification($order) {
		// Send confirmation email
		$Controller = new Controller();
		$Controller->helpers = ['BuzzTranslate.I18n'];
		$View = new View($Controller);
		$View->set('order', $order);
		$details = $View->render('BuzzPhotos./Orders/email_order', 'ajax');

		$orderUrl = Router::url(array(
			'admin' => false,
			'plugin' => 'buzz_photos',
			'controller' => 'orders',
			'action' => 'confirmation',
			$order['Order']['uuid']
		), true);

		$adminUrl = Router::url(array(
			'admin' => true,
			'plugin' => 'buzz_photos',
			'controller' => 'orders',
			'action' => 'view',
			$order['Order']['id']
		), true);

		$Email = ClassRegistry::init('BuzzEmails.Email');
		$email = ClassRegistry::init('BuzzEmails.Email')->generateEmailData(
			'BuzzPhotos.notification_email',
			[
				'uuid' => $order['Order']['uuid'],
				'fullName' => $order['Order']['first_name'] . ' ' . $order['Order']['last_name'],
				'firstName' => $order['Order']['first_name'],
				'lastName' => $order['Order']['last_name'],
				'phone' => $order['Order']['phone'],
				'email' => $order['Order']['email'],
				'billingAddress' => $order['Order']['billing_address'],
				'totalPrice' => $order['Order']['total_price'],
				'date' => date('j F Y', strtotime($order['Order']['created'])),
				'time' => date('H:i', strtotime($order['Order']['created'])),
				'details' => $details,
				'orderUrl' => $orderUrl,
				'adminUrl' => $adminUrl
			]
		);
		if (! empty($email)) {
			$Email->queueEmail(
				$email['Email']['subject'],
				$email['Email']['content'],
				array($order['Order']['email'] => $order['Order']['first_name'] . ' ' . $order['Order']['last_name']),
				$email['Email']['from']
			);
		}

		return;
	}

	protected function _sendConfirmation($order) {
		// Send confirmation email
		$Controller = new Controller();
		$Controller->helpers = ['BuzzTranslate.I18n'];
		$View = new View($Controller);
		$View->set('order', $order);
		$details = $View->render('BuzzPhotos./Orders/email_order', 'ajax');

		$orderUrl = Router::url(array(
			'admin' => false,
			'plugin' => 'buzz_photos',
			'controller' => 'orders',
			'action' => 'confirmation',
			$order['Order']['uuid']
		), true);

		$Email = ClassRegistry::init('BuzzEmails.Email');
		$email = ClassRegistry::init('BuzzEmails.Email')->generateEmailData(
			'BuzzPhotos.confirmation_email',
			[
				'uuid' => $order['Order']['uuid'],
				'fullName' => $order['Order']['first_name'] . ' ' . $order['Order']['last_name'],
				'firstName' => $order['Order']['first_name'],
				'lastName' => $order['Order']['last_name'],
				'phone' => $order['Order']['phone'],
				'email' => $order['Order']['email'],
				'billingAddress' => $order['Order']['billing_address'],
				'totalPrice' => $order['Order']['total_price'],
				'date' => date('j F Y', strtotime($order['Order']['created'])),
				'time' => date('H:i', strtotime($order['Order']['created'])),
				'details' => $details,
				'orderUrl' => $orderUrl
			]
		);
		if (! empty($email)) {
			$Email->queueEmail(
				$email['Email']['subject'],
				$email['Email']['content'],
				array($order['Order']['email'] => $order['Order']['first_name'] . ' ' . $order['Order']['last_name']),
				$email['Email']['from']
			);
		}

		return;
	}

}
