<?php
namespace Evoluted\BuzzPhotos\DiscountModifiers;

use Evoluted\PriceModifier\Interfaces\BasketInterface;
use Evoluted\PriceModifier\Interfaces\DiscountModifierInterface;

class FixedAmountModifier implements DiscountModifierInterface
{
	/**
     * @var Evoluted\PriceModifier\Interfaces\BasketInterface
     */
	protected $basket;

	/**
	 * @var Mixed A unique identifier for the discount. This can be a string or a number.
	 */
	protected $id;

	/**
	 * @var Array This contains any settings/data needed for this handler.
	 */
	protected $params = [
		'amount' => 0,
		'applyToItems' => false, // set to true to individually apply the discount to items instead of the basket total
		'quantity' => 0
	];

	protected $timesApplied = 0;

	/**
	 * Construct the discount handler
	 *
	 * @param mixed $id A unique identifier for this discount
	 * @param array $discountData Any data needed for the discount
	 * @param BasketInterface $basket The current basket to modify
	 */
	public function __construct($id, $discountData, BasketInterface $basket)
	{
		$this->id = $id;
		$this->params = array_merge($this->params, $discountData);
		$this->basket = $basket;
	}

	/**
	 * Applies the discount to the loaded basket.
	 *
	 * @return BasketInterface Returns the modified basket
	 */
	public function applyDiscount()
	{
		if ($this->params['applyToItems']) {
			foreach ($this->basket->items() as $key => $basketItem) {

				if ($this->params['amount'] > $basketItem->unit_price) {
					continue;
				}

				$discount = $this->params['amount'];
				$discount = $basketItem->unit_price - $discount;

				$this->basket->discount += $discount;

				$this->basket->item($key)->discount = $discount;
				$this->basket->item($key)->discount_type = 'F';
			}
		} else {
			$total = 0;
			foreach ($this->basket->items() as $key => $basketItem) {
				$total += $basketItem->unit_price;
			}

			$this->basket->discount = $total - $this->params['amount'];
		}

		return $this->basket;
	}

}
