<?php
App::uses('BuzzPhotosAppController', 'BuzzPhotos.Controller');
App::uses('ArrayUtil', 'EvCore.Lib');

class PhotoDiscountsController extends BuzzPhotosAppController {

	public $adminPaginate = array(
		'limit' => 25,
		'contain' => array(
			'PhotoDiscountType'
		)
	);

	protected function _adminPopulateLookups() {
		parent::_adminPopulateLookups();

		$this->loadModel('BuzzPhotos.PhotoDiscountType');
		$this->set('photoDiscountTypes', $this->PhotoDiscountType->find('list', array(
			'conditions' => array(
				'is_active' => 1
			)
		)));
	}

	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields['PhotoDiscount.discount_items']['label'] = 'Apply to each item?';
		$fields['PhotoDiscount.discount_items']['info'] = 'When checked, the discount will apply individually to each photo, instead of on the basket total. For some discount types this will not make any noticable difference, but can be used for fixed price changes to allow you to modify the item price instead of the basket total';

		return $fields;
	}

	protected function _adminIndexColumns() {
		$columns = parent::_adminIndexColumns();

		$extraColumns = array(
			'PhotoDiscount.code' => array(
				'type' => 'string',
				'label' => 'Code'
			),
			'PhotoDiscountType.name' => array(
				'type' => 'string',
				'label' => 'Discount Type',
			),
			'PhotoDiscount.start_date' => array(
				'type' => 'date',
				'label' => 'Start Date'
			),
			'PhotoDiscount.end_date' => array(
				'type' => 'date',
				'label' => 'End Date'
			),
		);

		unset($columns['PhotoDiscount.created']);

		return ArrayUtil::addAfter($columns, 'PhotoDiscount.name', $extraColumns);
	}

	protected function _adminFilterFields() {
		$fields = parent::_adminFilterFields();

		$extraFields = array(
			'PhotoDiscount.code' => array(
				'type' => 'string',
				'label' => 'Code',
				'compare' => array(
					'PhotoDiscount.code LIKE' => '%%%s%%'
				)
			),
			'PhotoDiscount.photo_discount_type_id' => array(
				'type' => 'select',
				'label' => 'Type',
				'compare' => array(
					'PhotoDiscount.photo_discount_type_id' => '%s'
				)
			)
		);


		return ArrayUtil::addAfter($fields, 'PhotoDiscount.name', $extraFields);
	}
}