<?php

class ActivityGroupsController extends BuzzPhotosAppController {

	public function beforeFilter() {
		parent::beforeFilter();
		$this->Auth->allow(array(
			'index',
			'view',
			'ajax_get_times',
			'album',
			'share'
		));
	}

	protected function _adminPopulateLookups() {
		parent::_adminPopulateLookups();
		$this->set('themes', array(1, 2, 3, 4));
	}

	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();
		$fields['ActivityGroup.theme_id']['empty'] = false;

		return $fields;
	}

	public function index() {
		if (Configure::read('BuzzPhotos.photos_page_id') > 0) {
			$this->assignPage(Configure::read('BuzzPhotos.photos_page_id'));
		}

		$activities = $this->{$this->modelClass}->find('all', array(
			'conditions' => array(
				'is_active' => 1
			),
			'contain' => array(
				'Image'
			)
		));
		$this->set('activities', $activities);
	}

	public function view($id) {
		$activity = $this->{$this->modelClass}->find('first', array(
			'conditions' => array(
				'id' => $id
			),
			'contain' => array(
				'FeatureImage'
			)
		));

		if (empty($activity)) {
			throw new NotFoundException;
		}

		$this->set('data', $activity);
	}

/**
 * Display an album
 * @param int $activityGroupId Activity group ID
 * @param int $id Album ID
 * @return void
 */
	public function album($activityGroupId, $id) {
		$this->loadModel('BuzzPhotos.PhotoApi');
		$album = null;
		if (! empty($id) && is_numeric($activityGroupId) && $id !== 'undefined') {
			$album = $this->PhotoApi->getAlbum($id);
		}
		if (empty($album['Images'])) {
			throw new NotFoundException();
		}

		$date = $this->_extractDate($album['AlbumDate']);

		$activities = array();

		foreach ($album['Images'] as $key => $image) {
			$activities[$key]['Image'] = array(
				'filename' => 'image.jpg',
				'filepath' => 'http://' . $image['ThumbKey'],
				'id' => $image['Id'],
				'type' => ''
			);

			$activities[$key]['PreviewImage'] = array(
				'filename' => 'image.jpg',
				'filepath' => 'http://' . $image['MediumKey'],
				'id' => $image['Id'],
				'type' => ''
			);
		}

		$this->set(compact('activities', 'date', 'activityGroupId'));
	}

	public function ajax_get_times($id, $date) {
		$activity = $this->{$this->modelClass}->find('first', array(
			'conditions' => array(
				'id' => $id,
				'is_active' => 1
			),
			'contain' => array(
				'Image'
			)
		));

		if (empty($activity)) {
			throw new NotFoundException;
		}

		$this->loadModel('BuzzPhotos.PhotoApi');
		$data = $this->PhotoApi->getTimes($activity['ActivityGroup']['api_key'], $date);

		$this->set(compact('data'));
		$this->layout = 'ajax';
	}

/**
 * Display an image shared on social media with a link back to the album.
 * @param int $activityGroupId Activity group ID
 * @param string $uuid Album UUID
 * @return void
 */
	public function share($activityGroupId, $uuid) {
		$image = null;
		if (! empty($uuid) && is_numeric($activityGroupId)) {
			$this->loadModel('BuzzPhotos.PhotoApi');
			$image = $this->PhotoApi->getImage($uuid);
		}

		if (empty($image)) {
			throw new NotFoundException;
		}

		$album = $this->PhotoApi->getAlbum($image['AlbumId']);

		// Extract and format the date
		$date = $this->_extractDate($album['AlbumDate']);

		$this->set(compact('image', 'album', 'date', 'activityGroupId'));
	}

	private function _extractDate($date) {
		$date = ltrim($date, '/Date(');
		$date = substr($date, 0, strpos($date, "+"));
		$date = $date / 1000;
		$date = date('jS F Y', $date);

		return $date;
	}

}
