<?php
class BuzzPhotosAddedOrderStatusAndCustomerRef extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzPhotos_added_order_status_and_customer_ref';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_table' => array(
				'buzz_photos_order_states' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'primary'),
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_general_ci', 'engine' => 'InnoDB'),
				),
			),
			'create_field' => array(
				'buzz_photos_orders' => array(
					'customer_address_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false, 'after' => 'last_name'),
					'order_state_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false, 'after' => 'discount_code'),
				),
			),
		),
		'down' => array(
			'drop_table' => array(
				'buzz_photos_order_states'
			),
			'drop_field' => array(
				'buzz_photos_orders' => array('customer_address_id', 'order_state_id'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			$data = array(
				array(
					'id' => 1,
					'name' => 'Unpaid'
				),
				array(
					'id' => 2,
					'name' => 'Complete'
				),
				array(
					'id' => 3,
					'name' => 'Payment Failed'
				),
				array(
					'id' => 4,
					'name' => 'API Failed'
				),
			);
			ClassRegistry::init('BuzzPhotos.OrderState')->saveMany($data);
		}
		return true;
	}
}
