<?php
class EvNavigationAddedUserGroupId extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'EvNavigation_added_user_group_id';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'menus' => array(
					'user_group_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false, 'after' => 'class'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'menus' => array('user_group_id'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			$this->_populateMenu();
		}
		return true;
	}

	protected function _populateMenu() {
		$data = array(
			array(
				'id' => 1,
				'parent_id' => null,
				'lft' => 1,
				'rght' => 12,
				'name' => 'Admin',
				'url' => null,
				'pattern' => null,
				'is_active' => true
			),
			array(
				'id' => 2,
				'parent_id' => 1,
				'lft' => 2,
				'rght' => 5,
				'name' => 'Users',
				'url' => '/admin/users',
				'pattern' => '/^\\/admin\\/users\\//',
				'is_active' => true
			),
			array(
				'id' => 3,
				'parent_id' => 1,
				'lft' => 3,
				'rght' => 4,
				'name' => 'User Groups',
				'url' => '/admin/user_groups',
				'pattern' => '/^\\/admin\\/user_groups\\//',
				'is_active' => true
			),
			array(
				'id' => 4,
				'parent_id' => 1,
				'lft' => 6,
				'rght' => 7,
				'name' => 'Menus',
				'url' => '/admin/menus',
				'pattern' => '/^\\/admin\\/menus\\//',
				'is_active' => true
			),
			array(
				'id' => 5,
				'parent_id' => 1,
				'lft' => 8,
				'rght' => 9,
				'name' => 'Pages',
				'url' => '/admin/pages',
				'pattern' => '/^\\/admin\\/pages\\//',
				'is_active' => true
			),
			array(
				'id' => 6,
				'parent_id' => 1,
				'lft' => 10,
				'rght' => 11,
				'name' => 'Site Settings',
				'url' => '/admin/site_settings',
				'pattern' => '/^\\/admin\\/site_settings\\//',
				'is_active' => true
			),
			array(
				'id' => 7,
				'parent_id' => null,
				'lft' => 13,
				'rght' => 14,
				'name' => 'Site',
				'url' => null,
				'pattern' => null,
				'is_active' => true
			),
			array(
				'id' => 8,
				'parent_id' => null,
				'lft' => 15,
				'rght' => 16,
				'name' => 'Footer',
				'url' => null,
				'pattern' => null,
				'is_active' => true
			)
		);
		return ClassRegistry::init('Navigation.Menu')->saveMany($data);
	}
}
