<?php echo $this->Html->docType('html5'); ?>
<html lang='en'>
<head>
	<!-- Latest compiled and minified CSS -->
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous" />
	<style type="text/css">
		.input {
			clear: both;
			padding-bottom: 1em;
			overflow: auto;
		}
		.input label {
			width: 200px;
			text-align: right;
			padding-right: 1em;
		}
		.input .select {
			float: left;
		}
		button {
			margin-left: 200px;
		}
	</style>
	<script type="text/javascript">
		document.onreadystatechange = function () {
			var app = {};
			var cardTypeInput = document.getElementById('PaymentCardType');
			/**
			 * Add class to element
			 * @param {object} el Element
			 * @param {string} className Class name to add
			 */
			app.addClass = function(el, className) {
				if (el.classList) {
					el.classList.add(className);
				} else {
					el.className += ' ' + className;
				}
			};
			/**
			 * Remove class from element
			 * @param {object} el Element
			 * @param {string} className Class name to remove
			 */
			app.removeClass = function(el, className) {
				if (el.classList) {
					el.classList.remove(className);
				} else {
					el.className = el.className.replace(new RegExp('(^|\\b)' + className.split(' ').join('|') + '(\\b|$)', 'gi'), ' ');
				}
			}
			/**
			 * Get the first element to match the class
			 * @param  {object} context Object to get elements from
			 * @param  {string} className Class name to match
			 * @return {object} First matched DOM element
			 */
			app.getElementByClass = function(context, className) {
				var elements = context.getElementsByTagName('*');;
				var regEx = new RegExp('\\b' + className + '\\b', 'g');
				// Scan for the first instance of the className
				for (var i = 0, totalElements = elements.length; i < totalElements; i++) {
					if (elements[i].className.match(regEx)) {
						return elements[i];
					}
				}

				return {};
			}
			/**
			 * Card type change logic
			 */
			app.changeCardType = function() {
				var startDate = app.getElementByClass(document, 'start-date');
				var issueNumber = app.getElementByClass(document, 'issue-number');
				if (this.value === 'maestro') {
					app.removeClass(startDate, 'hidden');
					app.removeClass(issueNumber, 'hidden');
				} else {
					app.addClass(startDate, 'hidden');
					app.addClass(issueNumber, 'hidden');
				}
			};
			if (cardTypeInput) {
				cardTypeInput.onchange = app.changeCardType;
				app.changeCardType.apply(cardTypeInput);
			}
		}
	</script>
</head>
<body>
	<div class="container-fluid">
		<div class="row">
			<div class="col-xs-12">
				<?= $this->Session->flash() ?>
				<?= $this->fetch('content') ?>
			</div>
		</div>
	</div>
</body>
