<?php
App::uses('BuzzMotoAppModel', 'BuzzMoto.Model');
App::uses('MotoPaymentState', 'BuzzMoto.Model');

class MotoPayment extends BuzzMotoAppModel {

	public $displayField = 'ref';

	public $displayName = 'Moto Payment';

	public $order = [
		'MotoPayment.modified' => 'desc'
	];

/**
 * Behaviors
 *
 * @var array
 */
	public $actsAs = [
		'BuzzPurchase.Payable'
	];

/**
 * Belongs to associations
 */
	public $belongsTo = [
		'CustomerAddress' => [
			'className' => 'BuzzCustomers.CustomerAddress'
		],
		'MotoPaymentState' => [
			'className' => 'BuzzMoto.MotoPaymentState'
		]
	];

/**
 * Create a MOTO payment request
 *
 * @param string $motoRef MOTO payment transaction reference (provided by user)
 * @param float $amount Amount due
 * @return bool
 */
	public function createPaymentRequest($motoRef, $amount) {
		$result = (bool)$this->save([
			'ref' => $motoRef,
			'amount' => $amount,
			'moto_payment_state_id' => MotoPaymentState::UNPAID
		]);

		// Set the 'basket' ID.
		if ($result === true) {
			$this->setBasketId($this->id);
		}

		return $result;
	}

	public function completePayment($paid) {
		$id = $this->getBasketId();
		$data = $this->findById($id);

		if ((int)$data['MotoPayment']['moto_payment_state_id'] === MotoPaymentState::UNPAID) {
			if ($paid === true) {
				$result = ClassRegistry::init('BuzzMoto.MotoApi')->completePayment(
					$this->name,
					$this->getBasketId(),
					$data['MotoPayment']['ref'],
					'Ok',
					'',
					$this->getPaymentDetails($id, 'BuzzMoto.MotoPayment')
				);
				$state = $result !== false ? MotoPaymentState::COMPLETE : MotoPaymentState::API_FAILED;
				$data = array(
					'id' => $id,
					'moto_payment_state_id' => $state
				);
				$response = $this->save($data);
			} else {
				// Mark as payment failed.
				$data = [
					'id' => $id,
					'moto_payment_state_id' => MotoPaymentState::PAYMENT_FAILED
				];
				$response = $this->save($data);
			}
		}
		// Clear the basket session.
		$this->clearBasketId();

		return $response;
	}

}
