<?php
App::uses('BuzzSourceAppModel', 'BuzzSource.Model');

class MotoApi extends BuzzSourceAppModel {

	/**
	 * Adds a MOTO payment via the API
	 *
	 * @param string $model Calling model name
	 * @param int $foreignId Calling model's ID
	 * @param int $vendortxcode
	 * @param string $status
	 * @param string $statusDetail
	 * @param array $payment
	 * @return bool
	 */
	public function completePayment($model, $foreignId, $vendortxcode, $status, $statusDetail, array $payment) {
		$result = $this->find('all', [
			'method' => 'CompletePayment',
			'conditions' => array(
				'vendortxcode' => $vendortxcode,
				'status' => $status,
				'statusdetail' => $statusDetail,
				'vpstxId' => $payment['vpstxId'],
				'cardno' => $payment['card_number'],
				'cardtype' => '',
				// Client wants to ensure a value is always passed for authno.
				'authno' => $payment['txauthno'] ?: 'moto'
			),
			'apiLog' => [
				'model' => $model,
				'foreign_id' => $foreignId
			]
		]);

		return !empty($result['MotoApi']['d']) && strtolower($result['MotoApi']['d']) === 'ok';
	}

}
