<?php
App::uses('AppHelper', 'View/Helper');

class MetaHelper extends AppHelper {

	public $helpers = ['Html'];

	public $settings = [
		'siteUrl' => null
	];

/**
 * Returns the meta tag for a canonical URL
 * @param string $route URL route
 * @param string $siteUrl Site URL (use to override default settings)
 * @return string
 */
	public function canonical($route, $siteUrl = null) {
		$siteUrl = $siteUrl ?: $this->settings['siteUrl'];
		// Strip preceding slash from route.
		$route = preg_replace('|^\/|', '', $route);

		return $this->Html->meta(
			'canonical',
			$siteUrl . '/' . $route,
			['rel' => 'canonical', 'type' => null, 'title' => null]
		);
	}

}
