<?php
App::uses('Component', 'Controller');
App::uses('TranslateUtil', 'BuzzTranslate.Lib');

class MetaComponent extends Component {

	private $__controller = null;

/**
 * Sets a reference to the calling controller from within the component.
 *
 * @see Component::initialize()
 */
	public function initialize(Controller $controller) {
		parent::initialize($controller);
		$this->__controller = $controller;
	}

/**
 * Sets the view variables for the meta data.
 *
 * @param array $data array containing the MetaData
 * @param string $overrideModel The main model, useful if setting Page content from within a plugin
 */
	public function set($data, $overrideModel = null) {
		$Model = $this->__controller->{$this->__controller->modelClass};

		if (isset($data['MetaData'])) {

			$this->__controller->set('metaTitle', TranslateUtil::translate($data, 'MetaData.title'));
			$this->__controller->set('metaDescription', TranslateUtil::translate($data, 'MetaData.description'));
			$this->__controller->set('metaKeywords', TranslateUtil::translate($data, 'MetaData.keywords'));

		}

		// override the Model, otherwise plugins will look at their own models
		// for the title when it may actually want to look at 'Page' Model.
		if (! empty($overrideModel)) {

			$this->__controller->loadModel($overrideModel);
			$Model = $this->__controller->{$overrideModel};
		}

		// Set the title for layout, either using the meta title, display
		// field, or model name.
		if (isset($data['MetaData']) && !empty($data['MetaData']['title'])) {
			$titleForLayout = TranslateUtil::translate($data, 'MetaData.title');
		} elseif (isset($data[$Model->alias][$Model->displayField])) {
			$titleForLayout = TranslateUtil::translate($data, $Model->alias . '.' . $Model->displayField) . ' | ' . Configure::read('SiteSetting.site_title');
		} else {
			$titleForLayout = InflectorExt::pluralize($Model->displayName) . ' | ' . Configure::read('SiteSetting.site_title');
		}
		$this->__controller->set('titleForLayout', $titleForLayout);
		// Set title_for_layout for backwards compatibility (CakePhp 2.4.x).
		$this->__controller->set('title_for_layout', $titleForLayout);

		return;
	}

/**
 * Set the canonical URL
 * @param string|array $url URL
 * @return void
 */
	public function canonical($url) {
		$this->__controller->set('canonicalUrl', Router::url($url));

		return;
	}

}
