jQuery(function($) {
	LateBookingsFilter();
});

function LateBookingsFilter() {
	var $form = $('.js-late-booking-filter');

	$form.data("validator").settings.submitHandler = function (form) { };

	$form.on('submit', function (e) {
		e.preventDefault();

		if ($('#LateBookingApiSiteId').is('select') && $('#LateBookingApiSiteId').val() <= 0) {

		} else {
			$('.js-late-booking-cal').html('').addClass('ajax-loading');
			$.ajax({
				'cache': false,
				'url': $form.attr('action'),
				'type': 'POST',
				'data': $form.serialize()
			}).done(function(data){
				$('.js-late-booking-cal').removeClass('ajax-loading').html(data);
				customFormElements();
				// Set the default date of the datepicker - this is so that we can select the first
				// day that has deals.
				var $datepicker = $('.datepicker');
				$datepicker.datepicker('setDate', new Date($datepicker.data('default-date')));
				// We want to load the deals for the default date.
				LateBookingsSelectDate();
				// Next we need to make sure that changing the date in the datepicker loads the new
				// deals.
				$datepicker.datepicker('option', 'onSelect', function() {
					return LateBookingsSelectDate();
				});
			});
		}
	});
}

/**
 * Load deals for the selected date.
 */
function LateBookingsSelectDate() {
	var $date = $('.js-late-booking-date');
	var $siteId = $('#LateBookingApiSiteId').val();
	$('.js-late-booking-deals').html('').addClass('ajax-loading');
	$.ajax({
		'cache': false,
		'url': $date.data('src') + '/' + $siteId + '/' + $date.val()
	}).done(function(data){
		$('.js-late-booking-deals').removeClass('ajax-loading');
		$('.js-late-booking-deals').html(data);
		customFormElements();
	});
}
