<?php
$this->extend('/Common/2col');
$title = __d('buzz_late_bookings', 'Late Deals');
if (!empty($data)):
	$title = $this->I18n->translate($data, 'Page.title');
endif;
$this->assign('title', $title);
$this->start('side');
?>
	<?php
		$adverts = count($data['Advert']);
		$i = 0;
		foreach ($data['Advert'] as $advert):
			echo $this->Advert->render($advert);
			++$i;
			echo $i < $adverts ? '<div class="content__spacer"></div>' : null;
		endforeach;
	?>
<?php $this->end(); // side ?>

<?= $this->Html->script(['BuzzLateBookings.buzz_late_bookings.min'], ['inline' => false]); ?>

<?php if (!empty($data['Image'][0])): ?>
	<div class="text-center">
		<?php echo $this->Img->resize($data['Image'][0], ['width' => 870], ['class' => 'full']); ?>
	</div>
	<div class="content__spacer"></div>
<?php endif; ?>

<?php echo $this->I18n->translate($data, 'Page.body'); ?>

<?php if (!empty($gallery) || !empty($data['Page']['video_url'])): ?>
	<div class="row">
		<?php
			if (!empty($gallery)):
				$class = !empty($data['Page']['video_url']) ? 'col-md-6' : 'col-md-12';
		?>
			<div class="col-xs-12 <?php echo $class; ?>">
				<?php echo $this->element('BuzzGallery.mini_gallery', ['data' => $gallery['GalleryImage']]); ?>

				<div class="content__spacer"></div>
			</div>
		<?php endif; ?>

		<?php
			if (!empty($data['Page']['video_url'])):
				$class = !empty($gallery) ? 'col-md-6' : 'col-md-12';
		?>
			<div class="col-xs-12 <?php echo $class; ?>">
				<div class="aspect aspect--16_9">
					<!-- force iframe to full width 16:9 ratio with css -->
					<?php echo !empty($data['Page']['video_url']) ? $this->Video->embed($data['Page']['video_url'], ['width' => '100%', 'height' => '100%']) : null; ?>
				</div>
				<div class="content__spacer"></div>
			</div>
		<?php endif; ?>
	</div>
<?php endif; ?>

<div class="row">
	<div class="col-xs-12">
		<div class="content__spacer"></div>

		<?php if (count($data['Tab'])): ?>
			<div class="responsivetabs">
				<ul>
					<li><?= $this->Html->link(__d('buzz_late_bookings', 'Deals'), '#tab-0'); ?></li>
					<?php $i = 0; ?>
					<?php foreach ($data['Tab'] as $tab): ?>
						<?php ++$i; ?>
						<li><?php echo $this->Html->link($this->I18n->translate($tab, 'title'), '#tab-' . $i); ?></li>
					<?php endforeach; ?>
				</ul>
				<div id="tab-0">
					<?= $this->element('BuzzLateBookings.filters') ?>
				</div>
				<?php $i = 0; ?>
				<?php foreach ($data['Tab'] as $tab): ?>
					<?php ++$i; ?>
					<div id="tab-<?php echo $i; ?>">
						<?php echo !empty($tab['Image'][0]) ? $this->Img->resize($tab['Image'][0], ['width' => 870], ['class' => 'center full']) . '<br />' : null; ?>
						<?php echo $this->I18n->translate($tab, 'content'); ?>
					</div>
				<?php endforeach; ?>
			</div>
		<?php else: ?>
			<h2><?= __d('buzz_late_bookings', 'Deals') ?></h2>
			<?= $this->element('BuzzLateBookings.filters') ?>
		<?php endif ?>

	</div>
</div>
