<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_late_bookings', 'Checkout'));
?>
<?php echo $this->Form->create(null, ['class' => 'validate']); ?>

<div class="content__spacer"></div>

<?= $this->element('BuzzLateBookings.late_bookings_basket', ['data' => $basket]); ?>

<div class="row">
	<div class="col-xs-12">
		<?php if ($basket['LateBooking']['total_cost'] > 0): ?>
			<h2><?php echo __d('buzz_late_bookings', 'Please enter your billing and payment details'); ?></h2>
		<?php else: ?>
			<h2><?php echo __d('buzz_late_bookings', 'Please enter your contact details'); ?></h2>
		<?php endif; ?>
	</div>
</div>

<div class="row">
	<div class="col-xs-12 col-md-6">
		<?php if ($basket['LateBooking']['total_cost'] > 0): ?>
			<h3><?php echo __d('buzz_late_bookings', 'Billing details'); ?></h3>
			<div class="form--side-labels form--compact validate">
				<?php echo $this->Element('BuzzCustomers.address_form'); ?>
				<?php echo $this->Form->input('CustomerAddress.telephone', ['label' => __d('buzz_late_bookings', 'Telephone')]); ?>
				<?php echo $this->Form->input('CustomerAddress.email', ['label' => __d('buzz_late_bookings', 'Email')]); ?>
			</div>
		<?php else: ?>
			<h3><?php echo __d('buzz_late_bookings', 'Contact details'); ?></h3>
			<div class="form--side-labels form--compact validate">
				<?php echo $this->Form->input('CustomerAddress.first_name', ['label' => __d('buzz_late_bookings', 'First name')]); ?>
				<?php echo $this->Form->input('CustomerAddress.last_name', ['label' => __d('buzz_late_bookings', 'Last name')]); ?>
				<?php echo $this->Form->input('CustomerAddress.telephone', ['label' => __d('buzz_late_bookings', 'Telephone')]); ?>
				<?php echo $this->Form->input('CustomerAddress.email', ['label' => __d('buzz_late_bookings', 'Email')]); ?>
			</div>
		<?php endif; ?>
	</div>
	<div class="col-xs-12 col-md-6">
		<h3><?php echo __d('buzz_late_bookings', 'Payment details'); ?></h3>
		<div class="form--side-labels form--compact validate">
			<?php echo $this->element('BuzzPurchase.Forms/payment_form'); ?>
		</div>
		<div class="content__spacer">&nbsp;</div>

		<?php foreach ($conditions as $condition): ?>
			<div class="input checkbox checkbox--custom checkbox--left clear">
				<?php echo $this->Form->checkbox('condition.' . $condition['Condition']['id'], ['class' => 'required']); ?>
				<?php echo $this->Form->label('condition.' . $condition['Condition']['id'], $condition['Condition']['rendered_content']); ?>
			</div>
		<?php endforeach; ?>

		<?php if (Configure::read('BuzzLateBookings.show_newsletter_opt_in') === true): ?>
			<div class="input checkbox checkbox--custom checkbox--left clear">
				<?= $this->Form->checkbox('LateBooking.newsletter_opt_in') ?>
				<?= $this->Form->label('LateBooking.newsletter_opt_in', __d('buzz_late_bookings', 'Signup to Exclusive Offers & News')) ?>
			</div>
		<?php endif; ?>
	</div>
</div>

<div class="booking__actions">
	<div class="row">
		<div class="col-xs-6">
			<?php echo $this->Html->link(__d('buzz_late_bookings', 'Back'), ['action' => 'basket'], ['class' => 'button button--light background--septenary left']); ?>
		</div>

		<div class="col-xs-6">
			<?php if ($basket['LateBooking']['total_cost'] > 0): ?>
				<?php echo $this->Form->button(__d('buzz_late_bookings', 'Pay Now') . '<i class="fa fa-credit-card fa-inline"></i>', ['class' => 'button button--dark background--senary right']); ?>
			<?php else: ?>
				<?php echo $this->Form->button(__d('buzz_late_bookings', 'Complete Booking'), ['class' => 'button button--dark background--senary right']); ?>
			<?php endif; ?>
		</div>
	</div>
</div>

<?php echo $this->Form->end(); ?>
