<?php $this->Extend('/Scaffolds/admin_form'); ?>
<?php $this->Append('additionalFormTabs'); ?>

	<?php
		if (!empty($booking['LateBooking']['completed_date'])):
			echo $this->Html->tag('div', $this->element('admin_purchase_details'), ['class' => 'tab__content', 'data-title' => __d('buzz_late_bookings', 'Details')]);
		endif;
	?>

	<?php
		if (
			!empty($booking['LateBooking']['api_log'])
			&& (int)$authUser['UserGroup']['id'] === 1
		):
			echo $this->Html->tag(
				'div',
				'<pre>' .  print_r(json_decode($booking['LateBooking']['api_log']), 1) . '</pre>',
				['class' => 'tab__content', 'data-title' => __d('buzz_late_bookings', 'API Errors')]
			);
		endif;
		if (!empty($apiCalls)):
			echo $this->Html->tag(
				'div',
				$this->element('BuzzSource.api_log'),
				['class' => 'tab__content', 'data-title' => __d('buzz_late_bookings', 'API Calls')]
			);
		endif;
	?>

<?php $this->end(); // additionalFormTabs end ?>

<?php

	echo $this->Form->addField('Booking.id', array(
		'type' => 'hidden'
	));

	echo $this->Form->addField(
		'LateBooking.sales_ref',
		array(
			'type' => 'string',
			'label' => __d('buzz_late_bookings', 'Sales Ref'),
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'LateBooking.booking_state_id',
		array(
			'type' => 'select',
			'label' => __d('buzz_late_bookings', 'Status'),
			'empty' => false,
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'LateBooking.completed_date',
		array(
			'type' => 'date',
			'label' => __d('buzz_late_bookings', 'Completed Date'),
			'displayonly' => true
		)
	);

	echo $this->Form->input('CustomerAddress.id');

	echo $this->Form->addField(
		'CustomerAddress.full_name',
		array(
			'type' => 'string',
			'label' => __d('buzz_late_bookings', 'Customer'),
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'CustomerAddress.email',
		array(
			'type' => 'email',
			'label' => __d('buzz_late_bookings', 'Email Address')
		)
	);

	echo $this->Form->addField(
		'CustomerAddress.telephone',
		array(
			'type' => 'tel',
			'label' => __d('buzz_late_bookings', 'Telephone')
		)
	);
?>

<div class="field">
	<div class="field__label"><?php echo __d('buzz_late_bookings', 'Total Cost'); ?></div>
	<div class="field__value">
		<?php echo $this->Number->currency($booking['LateBooking']['total_cost']); ?>
	</div>
</div>

<?php if (Configure::read('BuzzLateBookings.show_newsletter_opt_in') === true): ?>
	<div class="field">
		<div class="field__label">Newsletter Opt-in</div>
		<div class="field__value">
			<?php if ($booking['LateBooking']['newsletter_opt_in']): ?>
				<i class="fa fa-check"></i>
			<?php else: ?>
				<i class="fa fa-times"></i>
			<?php endif; ?>
		</div>
	</div>
<?php endif; ?>
