<?= $this->Form->create(null, ['url' => ['action' => 'book', 'ajax' => false]]) ?>
<?=$this->Form->hidden('api_site_id', ['value' => $siteId])?>
<div class="listing listing--activity listing--booking listing--late-deals js-listing-highlight">
	<div class="row">
		<div class="col-xs-12 col-md-2 xs-hidden sm-hidden">
			<?php
				$img = (empty($data['Image'][0])) ? 'no-image.png' : $data['Image'][0];
				echo $this->Image->resize($img, ['width' => 670, 'height' => 510, 'crop' => true, 'class' => 'listing__image', 'sharpen' => false, 'transparent' => true]);
			?>
		</div>

		<div class="col-xs-12 col-sm-9 col-md-7">
			<div class="row">
				<div class="col-xs-12 col-sm-6">
					<h3>
						<?= h($this->I18n->translate($data, 'LateBookingPackage.name')); ?>
					</h3>
				</div>
				<div class="col-xs-12 col-sm-3 xs-text-left text-right fa--senary">
					<?php if ($data['LateBookingPackage']['participants'] < 5): ?>
						<?php for ($i = 0; $i < $data['LateBookingPackage']['participants']; $i++): ?>
							<i class="fa fa-user"></i>
						<?php endfor; ?>
					<?php else: ?>
						<i class="fa fa-users"></i>
					<?php endif; ?>
					<strong><?= $data['LateBookingPackage']['participants']; ?></strong>
				</div>
				<div class="col-xs-12 col-sm-3 xs-text-left text-right fa--senary">
					<div class="listing__stat listing__stat--start-time">
						<i class="fa fa-clock-o"></i>
						<strong><?= $data['from_time']; ?></strong>
						<br />
						<small><?= __d('buzz_late_bookings', 'Start Time') ?></small>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-xs-12 col-sm-9">
				<?= $this->I18n->translate($data, 'LateBookingPackage.description'); ?>
				</div>
				<div class="col-xs-12 col-sm-3 text-center"><br />
					<?php if (! empty($data['quantity_required'])): ?>
						QTY <?= h($data['quantity_required']) ?>
						<?= $this->Form->hidden('LateBooking.quantity', ['value' => $data['quantity_required']]); ?>
					<?php else: ?>
						<?= $this->Form->hidden('LateBooking.quantity', ['value' => 1]); ?>
					<?php endif ?>
				</div>
			</div>

		</div>

		<div class="col-xs-12 col-sm-3 col-md-3 text-center">
			<span class="listing__price">
				<h3 class="color--offer"><?= $this->Number->price($data['LateBookingPackage']['price']) ?><br /></h3>
				<?= __d('buzz_late_bookings', 'Deal Price'); ?>
			</span>
			<div class="row">
				<?= $this->Form->hidden('LateBooking.key', ['value' => $key]); ?>
				<?= $this->Form->hidden('LateBooking.date', ['value' => $date]); ?>
				<?= $this->Form->button(__d('buzz_late_bookings', 'Book Now'), ['class' => 'button  button--submit']); ?>
			</div>
		</div>
	</div>
</div>
<?= $this->Form->end() ?>
